/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalCoordinateComparator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.StringLineReader;

public class IntervalList
implements Iterable<Interval> {
    private final SAMFileHeader header;
    private final List<Interval> intervals = new ArrayList<Interval>();

    public IntervalList(SAMFileHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("SAMFileHeader must be supplied.");
        }
        this.header = header;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    @Override
    public Iterator<Interval> iterator() {
        return this.intervals.iterator();
    }

    public void add(Interval interval) {
        this.intervals.add(interval);
    }

    public void sort() {
        Collections.sort(this.intervals, new IntervalCoordinateComparator(this.header));
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
    }

    public void unique() {
        this.sort();
        List<Interval> tmp = this.getUniqueIntervals();
        this.intervals.clear();
        this.intervals.addAll(tmp);
    }

    public List<Interval> getIntervals() {
        return Collections.unmodifiableList(this.intervals);
    }

    public List<Interval> getUniqueIntervals() {
        if (this.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            this.sort();
        }
        ArrayList<Interval> unique = new ArrayList<Interval>();
        ListIterator<Interval> iterator = this.intervals.listIterator();
        Interval previous = iterator.next();
        while (iterator.hasNext()) {
            Interval next = iterator.next();
            if (previous.intersects(next) || previous.abuts(next)) {
                previous = new Interval(previous.getSequence(), previous.getStart(), Math.max(previous.getEnd(), next.getEnd()), previous.isNegativeStrand(), previous.getName());
                continue;
            }
            unique.add(previous);
            previous = next;
        }
        if (previous != null) {
            unique.add(previous);
        }
        return unique;
    }

    public long getBaseCount() {
        return Interval.countBases(this.intervals);
    }

    public long getUniqueBaseCount() {
        return Interval.countBases(this.getUniqueIntervals());
    }

    public int size() {
        return this.intervals.size();
    }

    public static IntervalList fromFile(File file) {
        return IntervalList.fromReader(new BufferedReader(new InputStreamReader(IoUtil.openFileForReading(file))));
    }

    public static IntervalList fromReader(BufferedReader in) {
        try {
            StringBuilder builder = new StringBuilder(4096);
            String line = null;
            while ((line = in.readLine()) != null && line.startsWith("@")) {
                builder.append(line).append('\n');
            }
            if (builder.length() == 0) {
                throw new IllegalStateException("Interval list file must contain header. ");
            }
            StringLineReader headerReader = new StringLineReader(builder.toString());
            SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
            IntervalList list = new IntervalList(codec.decode((LineReader)headerReader, "BufferedReader"));
            FormatUtil format = new FormatUtil();
            do {
                boolean negative;
                if (line.trim().length() == 0) continue;
                String[] fields = line.split("\t");
                if (fields.length != 5) {
                    throw new PicardException("Invalid interval record contains " + fields.length + " fields: " + line);
                }
                String seq = fields[0];
                int start = format.parseInt(fields[1]);
                int end = format.parseInt(fields[2]);
                if (fields[3].equals("-")) {
                    negative = true;
                } else if (fields[3].equals("+")) {
                    negative = false;
                } else {
                    throw new IllegalArgumentException("Invalid strand field: " + fields[3]);
                }
                String name = fields[4];
                Interval interval = new Interval(seq, start, end, negative, name);
                list.intervals.add(interval);
            } while ((line = in.readLine()) != null);
            IntervalList intervalList = list;
            return intervalList;
        }
        catch (IOException ioe) {
            throw new PicardException("Error parsing interval list.", ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public void write(File file) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(IoUtil.openFileForWriting(file)));
            FormatUtil format = new FormatUtil();
            if (this.header != null) {
                SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                codec.encode((Writer)out, this.header);
            }
            for (Interval interval : this) {
                out.write(interval.getSequence());
                out.write(9);
                out.write(format.format(interval.getStart()));
                out.write(9);
                out.write(format.format(interval.getEnd()));
                out.write(9);
                out.write(interval.isPositiveStrand() ? 43 : 45);
                out.write(9);
                out.write(interval.getName());
                out.newLine();
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            throw new PicardException("Error writing out interval list to file: " + file.getAbsolutePath(), ioe);
        }
    }
}

