/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.List;
import net.sf.picard.util.CigarUtil;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;

public class CigarClippingIterator
implements CloseableIterator<SAMRecord> {
    private final CloseableIterator<SAMRecord> iterator;

    public CigarClippingIterator(CloseableIterator<SAMRecord> iterator) {
        this.iterator = iterator;
    }

    public SAMRecord next() {
        SAMRecord rec = (SAMRecord)this.iterator.next();
        if (!rec.getReadUnmappedFlag()) {
            SAMSequenceRecord refseq = rec.getHeader().getSequence(rec.getReferenceIndex().intValue());
            if (rec.getAlignmentEnd() > refseq.getSequenceLength()) {
                int clipFrom = refseq.getSequenceLength() - rec.getAlignmentStart() + 1;
                List<CigarElement> newCigarElements = CigarUtil.softClipEndOfRead(clipFrom, rec.getCigar().getCigarElements());
                rec.setCigar(new Cigar(newCigarElements));
            }
        }
        return rec;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void remove() {
        this.iterator.remove();
    }

    public void close() {
        this.iterator.close();
    }
}

