/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.IOException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultIOExceptionHandler
implements IOExceptionHandler {
    private static final Log LOG = LogFactory.getLog(DefaultIOExceptionHandler.class);
    private BrokerService broker;
    private boolean ignoreAllErrors = false;
    private boolean ignoreNoSpaceErrors = true;
    private String noSpaceMessage = "space";

    public void handle(IOException exception) {
        if (this.ignoreAllErrors) {
            LOG.info("Ignoring IO exception, " + exception, exception);
            return;
        }
        if (this.ignoreNoSpaceErrors) {
            for (Throwable cause = exception; cause != null && cause instanceof IOException; cause = cause.getCause()) {
                if (!cause.getMessage().contains(this.noSpaceMessage)) continue;
                LOG.info("Ignoring no space left exception, " + exception, exception);
                return;
            }
        }
        LOG.info("Stopping the broker due to IO exception, " + exception, exception);
        new Thread(){

            public void run() {
                try {
                    DefaultIOExceptionHandler.this.broker.stop();
                }
                catch (Exception e) {
                    LOG.warn("Failure occured while stopping broker", e);
                }
            }
        }.start();
    }

    public void setBrokerService(BrokerService broker) {
        this.broker = broker;
    }

    public boolean isIgnoreAllErrors() {
        return this.ignoreAllErrors;
    }

    public void setIgnoreAllErrors(boolean ignoreAllErrors) {
        this.ignoreAllErrors = ignoreAllErrors;
    }

    public boolean isIgnoreNoSpaceErrors() {
        return this.ignoreNoSpaceErrors;
    }

    public void setIgnoreNoSpaceErrors(boolean ignoreNoSpaceErrors) {
        this.ignoreNoSpaceErrors = ignoreNoSpaceErrors;
    }

    public String getNoSpaceMessage() {
        return this.noSpaceMessage;
    }

    public void setNoSpaceMessage(String noSpaceMessage) {
        this.noSpaceMessage = noSpaceMessage;
    }
}

