/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.entity.HCTreeNodeEntity;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.RendererState;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.ui.RectangleEdge;

public class HCPlotState
extends RendererState {
    private int blockMinX;
    private int blockMinY;
    private int sizeOfNodeSymbol;
    private double blockWidth;
    private double blockHeight;
    private double columnTreeHeightUnitInPixels;
    private double rowTreeHeightUnitInPixels;

    public HCPlotState(PlotRenderingInfo info, int blockMinX, int blockMinY, int sizeOfNodeSymbol, double blockWidth, double blockHeight, double columnTreeHeightUnitInPixels, double rowTreeHeightUnitInPixels) {
        super(info);
        this.blockMinX = blockMinX;
        this.blockMinY = blockMinY;
        this.sizeOfNodeSymbol = sizeOfNodeSymbol;
        this.blockWidth = blockWidth;
        this.blockHeight = blockHeight;
        this.columnTreeHeightUnitInPixels = columnTreeHeightUnitInPixels;
        this.rowTreeHeightUnitInPixels = rowTreeHeightUnitInPixels;
    }

    public int getSizeOfNodeSymbol() {
        return this.sizeOfNodeSymbol;
    }

    public double getBlockWidth() {
        return this.blockWidth;
    }

    public double getBlockHeight() {
        return this.blockHeight;
    }

    public double getColumnTreeHeightUnitInPixels() {
        return this.columnTreeHeightUnitInPixels;
    }

    public double getRowTreeHeightUnitInPixels() {
        return this.rowTreeHeightUnitInPixels;
    }

    public int getHeatMapXCoordinate(int column) {
        return (int)((double)column * this.blockWidth + (double)this.blockMinX);
    }

    public int getHeatMapYCoordinate(int row) {
        return (int)((double)row * this.blockHeight + (double)this.blockMinY);
    }

    public Rectangle calculateSubTreeArea(Rectangle2D totalArea, Rectangle2D usedArea, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            return new Rectangle((int)(totalArea.getMinX() + usedArea.getWidth()), (int)totalArea.getMinY(), (int)(totalArea.getWidth() - usedArea.getWidth()), (int)totalArea.getHeight());
        }
        if (edge == RectangleEdge.BOTTOM) {
            return new Rectangle((int)(totalArea.getMinX() + usedArea.getWidth()), (int)totalArea.getMinY(), (int)(totalArea.getWidth() - usedArea.getWidth()), (int)totalArea.getHeight());
        }
        if (edge == RectangleEdge.LEFT) {
            return new Rectangle((int)totalArea.getMinX(), (int)(totalArea.getMinY() + usedArea.getHeight()), (int)totalArea.getWidth(), (int)(totalArea.getHeight() - usedArea.getHeight()));
        }
        if (edge == RectangleEdge.RIGHT) {
            return new Rectangle((int)totalArea.getMinX(), (int)(totalArea.getMaxY() + usedArea.getHeight()), (int)totalArea.getWidth(), (int)(totalArea.getHeight() - usedArea.getHeight()));
        }
        throw new IllegalArgumentException("Invalid edge.");
    }

    public Point calculateBranchNodeCenter(double height, HCTreeNodeEntity leftEntity, HCTreeNodeEntity rightEntity, Rectangle2D area, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            return new Point((int)((leftEntity.getCenter().getX() + rightEntity.getCenter().getX()) / 2.0), (int)(area.getMaxY() - height * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.BOTTOM) {
            return new Point((int)((leftEntity.getCenter().getX() + rightEntity.getCenter().getX()) / 2.0), (int)(area.getMinY() + height * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.LEFT) {
            return new Point((int)(area.getMaxX() - height * this.rowTreeHeightUnitInPixels), (int)((leftEntity.getCenter().getY() + rightEntity.getCenter().getY()) / 2.0));
        }
        if (edge == RectangleEdge.RIGHT) {
            return new Point((int)(area.getMinX() + height * this.rowTreeHeightUnitInPixels), (int)((leftEntity.getCenter().getY() + rightEntity.getCenter().getY()) / 2.0));
        }
        throw new IllegalArgumentException("Invalid edge.");
    }

    public Rectangle calculateBranchNodeArea(double height, HCTreeNodeEntity leftEntity, HCTreeNodeEntity rightEntity, Rectangle2D area, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            return new Rectangle((int)leftEntity.getCenter().getX(), (int)(area.getMaxY() - height * this.columnTreeHeightUnitInPixels), (int)(rightEntity.getCenter().getX() - leftEntity.getCenter().getX()), (int)(height * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.BOTTOM) {
            return new Rectangle((int)leftEntity.getCenter().getX(), (int)area.getMinY(), (int)(rightEntity.getCenter().getX() - leftEntity.getCenter().getX()), (int)(height * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.LEFT) {
            return new Rectangle((int)(area.getMaxX() - height * this.rowTreeHeightUnitInPixels), (int)leftEntity.getCenter().getY(), (int)(height * this.rowTreeHeightUnitInPixels), (int)(rightEntity.getCenter().getY() - leftEntity.getCenter().getY()));
        }
        if (edge == RectangleEdge.RIGHT) {
            return new Rectangle((int)area.getMinX(), (int)leftEntity.getCenter().getY(), (int)(height * this.rowTreeHeightUnitInPixels), (int)(rightEntity.getCenter().getY() - leftEntity.getCenter().getY()));
        }
        throw new IllegalArgumentException("Invalid edge.");
    }

    public Rectangle calculateLeafNodeArea(Rectangle2D area, HCTreeNodeInfo info, RectangleEdge edge) {
        int index;
        HCTreeNode node = info.getNode();
        try {
            index = info.getVisibleDataRange().getLeftBound();
        }
        catch (Exception e) {
            index = 0;
        }
        if (edge == RectangleEdge.TOP) {
            return new Rectangle(this.getHeatMapXCoordinate(index), (int)(area.getMaxY() - node.getHeight() * this.columnTreeHeightUnitInPixels), (int)this.getBlockWidth(), (int)(node.getHeight() * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.BOTTOM) {
            return new Rectangle(this.getHeatMapXCoordinate(index), (int)area.getMinY(), (int)this.getBlockWidth(), (int)(node.getHeight() * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.LEFT) {
            return new Rectangle((int)(area.getMaxX() - (double)((int)(node.getHeight() * this.rowTreeHeightUnitInPixels))), this.getHeatMapYCoordinate(index), (int)(node.getHeight() * this.rowTreeHeightUnitInPixels), (int)this.getBlockHeight());
        }
        if (edge == RectangleEdge.RIGHT) {
            return new Rectangle((int)area.getMinX(), this.getHeatMapYCoordinate(index), (int)(node.getHeight() * this.rowTreeHeightUnitInPixels), (int)this.getBlockHeight());
        }
        throw new IllegalArgumentException("Invalid edge.");
    }

    public Point calculateLeafNodeCenter(Rectangle2D area, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            return new Point((int)area.getCenterX(), (int)area.getMaxY());
        }
        if (edge == RectangleEdge.BOTTOM) {
            return new Point((int)area.getCenterX(), (int)area.getMinY());
        }
        if (edge == RectangleEdge.LEFT) {
            return new Point((int)area.getMaxX(), (int)area.getCenterY());
        }
        if (edge == RectangleEdge.RIGHT) {
            return new Point((int)area.getMinX(), (int)area.getCenterY());
        }
        throw new IllegalArgumentException("Invalid edge.");
    }

    public Rectangle calculateClosedNodeArea(Rectangle2D area, HCTreeNodeInfo info, RectangleEdge edge) {
        return this.calculateLeafNodeArea(area, info, edge);
    }

    public Point calculateClosedNodeCenter(Rectangle2D area, double height, RectangleEdge edge) {
        if (edge == RectangleEdge.TOP) {
            return new Point((int)area.getCenterX(), (int)(area.getMaxY() - height * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.BOTTOM) {
            return new Point((int)area.getCenterX(), (int)(area.getMinY() + height * this.columnTreeHeightUnitInPixels));
        }
        if (edge == RectangleEdge.LEFT) {
            return new Point((int)(area.getMaxX() - height * this.rowTreeHeightUnitInPixels), (int)area.getCenterY());
        }
        if (edge == RectangleEdge.RIGHT) {
            return new Point((int)(area.getMinX() + height * this.rowTreeHeightUnitInPixels), (int)area.getCenterY());
        }
        throw new IllegalArgumentException("Invalid edge.");
    }
}

