/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.data.hc.DataRange;

public abstract class AbstractHCClusteringInfo {
    protected LinkedList listeners;
    protected int location;
    protected String[] names;

    public abstract List getNames();

    public abstract HCTreeNodeInfo getRootNode();

    public abstract DataRange getDataRangeForVisibleIndex(int var1);

    public abstract int getNumberOfVisibleItems();

    public String getName(DataRange range) {
        String rightName;
        String leftName;
        int rightBound;
        int leftBound;
        try {
            leftBound = range.getLeftBound();
            rightBound = range.getRightBound();
        }
        catch (Exception e) {
            return "[]";
        }
        try {
            leftName = this.names[leftBound];
            rightName = this.names[rightBound];
        }
        catch (Exception e) {
            leftName = "" + leftBound;
            rightName = "" + rightBound;
        }
        if (leftBound == rightBound) {
            return leftName;
        }
        return leftName + " - " + rightName;
    }

    public int getLocation() {
        return this.location;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyChangeListeners(ChangeEvent event) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }
}

