package org.jfree.chart.plot.junit;

import org.jfree.chart.plot.HCMediator;
import org.jfree.chart.plot.*;
import org.jfree.data.hc.*;
import java.util.*;
import org.jfree.chart.plot.StandardHCClusteringInfo;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Tests for the {@link HCMediator} class.
 */
public class HCMediatorTests extends TestCase {

    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(HCMediatorTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HCMediatorTests(String name) {
        super(name);
    }


    /**
     * The test.
     */
    public void testGet(){

	HCTreeNode node = new HCTreeNode(1.0);
	StandardHCClusteringInfo cInfo = new StandardHCClusteringInfo(new HCTreeNode(1.0), new String[]{"names","names"},1);
	HCTreeNodeInfo info = new HCTreeNodeInfo(cInfo,node);
	

	LinkedList list = new LinkedList();
	list.add(info);

	HCMediator medi = new HCMediator(cInfo);

	LinkedList l = (LinkedList)medi.getCategories();

	assertTrue(list.getFirst().toString().equals(l.getFirst().toString()));


	// testing null parameter value	
	try {
	  medi = new HCMediator(null);
	  assertTrue(true);
	} catch (Exception e){;}

	try {
	  medi = new HCMediator(null);
	  assertEquals(medi.getCategories(),null);
	} catch (Exception e){;}

    }
}
