
package org.jfree.chart.editor.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.Assert;

import javax.swing.JPanel;
import java.awt.event.*;
import javax.swing.event.*;

import java.awt.*;
import java.util.*;
import javax.swing.*;

import org.jfree.chart.editor.HCOptionsEditor;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.plot.junit.*;

/**
 * Tests for the {@link org.jfree.chart.entity.HeatMapBlockEntity} class.
 */
public class HCOptionsEditorTests extends TestCase {


    /**
     * Returns the tests as a test suite.
     *
     * @return The test suite.   

     */
    public static Test suite() {
        return new TestSuite(HCOptionsEditorTests.class);
    }

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HCOptionsEditorTests(String name) {
        super(name);
    }

    /**
     * Does the tests.
     */
    public void testHCOptionsEditor(){
    
	

	try {
	
	HCPlot plot = new HCPlot(HCPlotTests.createDataset(2,3,true,true));
    	HCOptionsEditor editor = new HCOptionsEditor(plot);
	JPanel panel = editor.getPanel();



	Component[] compo = panel.getComponents();
     
	for (int i=0; i < compo.length; ++i){
		if (compo[i] instanceof JCheckBox){
                        if (((JCheckBox)compo[i]).getText().equals("Show column clustering")) {
			    ((JCheckBox)compo[i]).setSelected(false);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(!plot.getColumnTreeVisibility());
			    ((JCheckBox)compo[i]).setSelected(true);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(plot.getColumnTreeVisibility());
                        }
                        if (((JCheckBox)compo[i]).getText().equals("Show row clustering")) {
			    ((JCheckBox)compo[i]).setSelected(false);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(!plot.getRowTreeVisibility());
			    ((JCheckBox)compo[i]).setSelected(true);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(plot.getRowTreeVisibility());
                        }
                        if (((JCheckBox)compo[i]).getText().equals("Show column names")) {
			    ((JCheckBox)compo[i]).setSelected(false);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(!plot.getColumnNamesVisibility());
			    ((JCheckBox)compo[i]).setSelected(true);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(plot.getColumnNamesVisibility());
                        }
                        if (((JCheckBox)compo[i]).getText().equals("Show row names")) {
			    ((JCheckBox)compo[i]).setSelected(false);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(!plot.getRowNamesVisibility());
			    ((JCheckBox)compo[i]).setSelected(true);
			    editor.stateChanged(new ChangeEvent(compo[i]));
                            assertTrue(plot.getRowNamesVisibility());
                        }
		}
	}


	} catch (Exception e){
		;
	}
    }
}
