/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.SslBrokerService;
import org.apache.activemq.transport.TransportBrokerTestSupport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.tcp.SslTransportFactory;

public class SslBrokerServiceTest
extends TransportBrokerTestSupport {
    protected String getBindLocation() {
        return "ssl://localhost:0";
    }

    protected BrokerService createBroker() throws Exception {
        SslBrokerService service = new SslBrokerService();
        service.setPersistent(false);
        KeyManager[] km = this.getKeyManager();
        TrustManager[] tm = this.getTrustManager();
        this.connector = service.addSslConnector(this.getBindLocation(), km, tm, null);
        SslTransportFactory sslFactory = new SslTransportFactory();
        sslFactory.setKeyAndTrustManagers(km, tm, null);
        TransportFactory.registerTransportFactory("ssl", sslFactory);
        return service;
    }

    private TrustManager[] getTrustManager() throws Exception {
        TrustManager[] trustStoreManagers = null;
        KeyStore trustedCertStore = KeyStore.getInstance("jks");
        trustedCertStore.load(new FileInputStream("src/test/resources/client.keystore"), null);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustedCertStore);
        trustStoreManagers = tmf.getTrustManagers();
        return trustStoreManagers;
    }

    private KeyManager[] getKeyManager() throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("jks");
        KeyManager[] keystoreManagers = null;
        byte[] sslCert = SslBrokerServiceTest.loadClientCredential("src/test/resources/server.keystore");
        if (sslCert != null && sslCert.length > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(sslCert);
            ks.load(bin, "password".toCharArray());
            kmf.init(ks, "password".toCharArray());
            keystoreManagers = kmf.getKeyManagers();
        }
        return keystoreManagers;
    }

    private static byte[] loadClientCredential(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        FileInputStream in = new FileInputStream(fileName);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        int i = in.read(buf);
        while (i > 0) {
            out.write(buf, 0, i);
            i = in.read(buf);
        }
        in.close();
        return out.toByteArray();
    }

    protected void setUp() throws Exception {
        this.maxWait = 10000;
        super.setUp();
    }

    public static Test suite() {
        return SslBrokerServiceTest.suite(SslBrokerServiceTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SslBrokerServiceTest.suite());
    }
}

