/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.tree;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.tree.TreeIndex;

public class TreeTest
extends TestCase {
    private static final int COUNT = 55;
    private TreeIndex tree;
    private File directory;
    private IndexManager indexManager;
    private boolean dumpTree;

    protected void setUp() throws Exception {
        super.setUp();
        this.directory = new File("activemq-data");
        this.directory.mkdirs();
        this.indexManager = new IndexManager(this.directory, "im-test", "rw", null, new AtomicLong());
        this.tree = new TreeIndex(this.directory, "testTree", this.indexManager);
        this.tree.setKeyMarshaller(Store.STRING_MARSHALLER);
    }

    public void testTreeWithCaching() throws Exception {
        this.tree.setEnablePageCaching(true);
    }

    public void testTreeWithoutCaching() throws Exception {
        this.tree.setEnablePageCaching(false);
    }

    public void doTest() throws Exception {
        this.doTest(600);
    }

    public void doTest(int pageSize) throws Exception {
        String keyRoot = "key:";
        this.tree.setPageSize(pageSize);
        this.tree.load();
        this.doInsert(keyRoot);
        this.doRemoveBackwards(keyRoot);
    }

    void doInsert(String keyRoot) throws Exception {
        for (int i = 0; i < 55; ++i) {
            IndexItem value = this.indexManager.createNewIndex();
            this.indexManager.storeIndex(value);
            this.tree.store(keyRoot + i, value);
        }
    }

    void checkRetrieve(String keyRoot) throws IOException {
        for (int i = 0; i < 55; ++i) {
            IndexItem item = (IndexItem)this.tree.get(keyRoot + i);
            TreeTest.assertNotNull((Object)item);
        }
    }

    void doRemove(String keyRoot) throws Exception {
        int i;
        for (i = 0; i < 55; ++i) {
            this.tree.remove(keyRoot + i);
        }
        for (i = 0; i < 55; ++i) {
            IndexItem item = (IndexItem)this.tree.get(keyRoot + i);
            TreeTest.assertNull((Object)item);
        }
    }

    void doRemoveBackwards(String keyRoot) throws Exception {
        int i;
        for (i = 54; i >= 0; --i) {
            this.tree.remove(keyRoot + i);
            System.out.println("BACK Removed " + keyRoot + i);
            this.tree.getRoot().dump();
            System.out.println("");
        }
        for (i = 0; i < 55; ++i) {
            IndexItem item = (IndexItem)this.tree.get(keyRoot + i);
            TreeTest.assertNull((Object)item);
        }
    }

    protected void tearDown() throws Exception {
        File[] files;
        super.tearDown();
        for (File file : files = this.directory.listFiles()) {
            file.delete();
        }
    }
}

