/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.util.ByteSequence;

public class DataFileAppenderTest
extends TestCase {
    AsyncDataManager dataManager;
    File dir;

    public void setUp() throws Exception {
        this.dir = new File("target/tests/DataFileAppenderTest");
        this.dir.mkdirs();
        this.dataManager = new AsyncDataManager();
        this.dataManager.setDirectory(this.dir);
        this.configure(this.dataManager);
        this.dataManager.start();
    }

    protected void configure(AsyncDataManager dataManager) {
        dataManager.setUseNio(false);
    }

    public void tearDown() throws Exception {
        this.dataManager.close();
        this.deleteFilesInDirectory(this.dir);
        this.dir.delete();
    }

    private void deleteFilesInDirectory(File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.deleteFilesInDirectory(f);
            }
            f.delete();
        }
    }

    public void testBatchWriteCallbackCompleteAfterTimeout() throws Exception {
        int iterations = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        ByteSequence data = new ByteSequence("DATA".getBytes());
        for (int i = 0; i < 10; ++i) {
            this.dataManager.write(data, new Runnable(){

                public void run() {
                    latch.countDown();
                }
            });
        }
        DataFileAppenderTest.assertTrue((String)"queued data is written", (boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    public void testBatchWriteCallbackCompleteAfterClose() throws Exception {
        int iterations = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        ByteSequence data = new ByteSequence("DATA".getBytes());
        for (int i = 0; i < 10; ++i) {
            this.dataManager.write(data, new Runnable(){

                public void run() {
                    latch.countDown();
                }
            });
        }
        this.dataManager.close();
        DataFileAppenderTest.assertTrue((String)"queued data is written", (boolean)this.dataManager.getInflightWrites().isEmpty());
        DataFileAppenderTest.assertEquals((String)"none written", (long)0L, (long)latch.getCount());
    }

    public void testBatchWriteCompleteAfterClose() throws Exception {
        ByteSequence data = new ByteSequence("DATA".getBytes());
        int iterations = 10;
        for (int i = 0; i < 10; ++i) {
            this.dataManager.write(data, false);
        }
        this.dataManager.close();
        DataFileAppenderTest.assertTrue((String)("queued data is written:" + this.dataManager.getInflightWrites().size()), (boolean)this.dataManager.getInflightWrites().isEmpty());
    }

    public void testBatchWriteToMaxMessageSize() throws Exception {
        int iterations = 4;
        final CountDownLatch latch = new CountDownLatch(4);
        Runnable done = new Runnable(){

            public void run() {
                latch.countDown();
            }
        };
        int messageSize = 0x100000;
        byte[] message = new byte[messageSize];
        ByteSequence data = new ByteSequence(message);
        for (int i = 0; i < 4; ++i) {
            this.dataManager.write(data, done);
        }
        DataFileAppenderTest.assertTrue((String)"all callbacks complete", (boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    public void testNoBatchWriteWithSync() throws Exception {
        ByteSequence data = new ByteSequence("DATA".getBytes());
        int iterations = 10;
        for (int i = 0; i < 10; ++i) {
            this.dataManager.write(data, true);
            DataFileAppenderTest.assertTrue((String)"queued data is written", (boolean)this.dataManager.getInflightWrites().isEmpty());
        }
    }
}

