/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.List;
import org.apache.activemq.util.ByteSequence;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.component.mock.MockEndpoint;

public class JournalRouteTest
extends ContextTestSupport {
    public void testSimpleJournalRoute() throws Exception {
        byte[] payload = "Hello World".getBytes();
        MockEndpoint resultEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:out", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        AssertionClause firstMessageExpectations = resultEndpoint.message(0);
        firstMessageExpectations.header("journal").isEqualTo((Object)"activemq.journal:target/test.a");
        firstMessageExpectations.header("location").isNotNull();
        firstMessageExpectations.body().isInstanceOf(ByteSequence.class);
        this.template.sendBody("direct:in", (Object)payload);
        resultEndpoint.assertIsSatisfied();
        List list = resultEndpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        ByteSequence body = (ByteSequence)exchange.getIn().getBody();
        body.compact();
        JournalRouteTest.assertEquals((String)"body", (String)new String(payload), (String)new String(body.data));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:in").to("activemq.journal:target/test.a");
                this.from("activemq.journal:target/test.a").to("mock:out");
            }
        };
    }
}

