/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.message.security;

import java.io.IOException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.camel.CamelEmbeddedBrokerTestSupport;
import org.apache.activemq.command.Message;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class MessageAuthenticationTest
extends CamelEmbeddedBrokerTestSupport {
    public void testSendInvalidMessage() throws Exception {
        MockEndpoint results = this.getMockEndpoint("mock:results");
        results.expectedBodiesReceived(new Object[]{"validBody"});
        this.template.sendBodyAndHeader("activemq:MyQueue", (Object)"invalidBody", "myHeader", (Object)"xyz");
        this.template.sendBodyAndHeader("activemq:MyQueue", (Object)"validBody", "myHeader", (Object)"abc");
        this.assertMockEndpointsSatisifed();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setMessageAuthorizationPolicy(new MessageAuthorizationPolicy(){

            public boolean isAllowedToConsume(ConnectionContext context, Message message) {
                try {
                    Object value = message.getProperty("myHeader");
                    return "abc".equals(value);
                }
                catch (IOException e) {
                    System.out.println("Caught: " + e);
                    e.printStackTrace();
                    return false;
                }
            }
        });
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void addCamelRoutes(CamelContext camelContext) throws Exception {
        camelContext.addRoutes(new RouteBuilder(){

            public void configure() throws Exception {
                this.from("activemq:MyQueue").to("mock:results");
            }
        });
    }
}

