/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorSelection;

public class SelectorWorker
implements Runnable {
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    final SelectorManager manager;
    final Selector selector;
    final int id = NEXT_ID.getAndIncrement();
    final AtomicInteger useCounter = new AtomicInteger();
    private final int maxChannelsPerWorker;

    public SelectorWorker(SelectorManager manager) throws IOException {
        this.manager = manager;
        this.selector = Selector.open();
        this.maxChannelsPerWorker = manager.getMaxChannelsPerWorker();
    }

    void incrementUseCounter() {
        int use = this.useCounter.getAndIncrement();
        if (use == 0) {
            this.manager.getSelectorExecutor().execute(this);
        } else if (use + 1 == this.maxChannelsPerWorker) {
            this.manager.onWorkerFullEvent(this);
        }
    }

    void decrementUseCounter() {
        int use = this.useCounter.getAndDecrement();
        if (use == 1) {
            this.manager.onWorkerEmptyEvent(this);
        } else if (use == this.maxChannelsPerWorker) {
            this.manager.onWorkerNotFullEvent(this);
        }
    }

    boolean isRunning() {
        return this.useCounter.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SelectorSelection s;
        Set<SelectionKey> keys;
        String origName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName("Selector Worker: " + this.id);
            while (this.isRunning()) {
                int count = this.selector.select(10L);
                if (count == 0) continue;
                if (!this.isRunning()) {
                    return;
                }
                keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    SelectionKey key = i.next();
                    i.remove();
                    s = (SelectorSelection)key.attachment();
                    try {
                        s.disable();
                        this.manager.getChannelExecutor().execute(new Runnable(){

                            public void run() {
                                try {
                                    s.onSelect();
                                    s.enable();
                                }
                                catch (Throwable e) {
                                    s.onError(e);
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        s.onError(e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.manager.onWorkerEmptyEvent(this);
            keys = this.selector.keys();
            for (SelectionKey key : keys) {
                s = (SelectorSelection)key.attachment();
                s.onError(e);
            }
        }
        finally {
            Thread.currentThread().setName(origName);
        }
    }
}

