/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;

public class DemandSubscription {
    private ConsumerInfo remoteInfo;
    private ConsumerInfo localInfo;
    private Set<ConsumerId> remoteSubsIds = new CopyOnWriteArraySet<ConsumerId>();
    private AtomicInteger dispatched = new AtomicInteger(0);

    DemandSubscription(ConsumerInfo info) {
        this.remoteInfo = info;
        this.localInfo = info.copy();
        this.localInfo.setBrokerPath(info.getBrokerPath());
        this.localInfo.setNetworkSubscription(true);
        this.remoteSubsIds.add(info.getConsumerId());
    }

    public boolean add(ConsumerId id) {
        if (this.localInfo != null) {
            this.localInfo.addNetworkConsumerId(id);
        }
        return this.remoteSubsIds.add(id);
    }

    public boolean remove(ConsumerId id) {
        if (this.localInfo != null) {
            this.localInfo.removeNetworkConsumerId(id);
        }
        return this.remoteSubsIds.remove(id);
    }

    public boolean isEmpty() {
        return this.remoteSubsIds.isEmpty();
    }

    public int getDispatched() {
        return this.dispatched.get();
    }

    public void setDispatched(int dispatched) {
        this.dispatched.set(dispatched);
    }

    public int incrementDispatched() {
        return this.dispatched.incrementAndGet();
    }

    public ConsumerInfo getLocalInfo() {
        return this.localInfo;
    }

    public void setLocalInfo(ConsumerInfo localInfo) {
        this.localInfo = localInfo;
    }

    public ConsumerInfo getRemoteInfo() {
        return this.remoteInfo;
    }

    public void setRemoteInfo(ConsumerInfo remoteInfo) {
        this.remoteInfo = remoteInfo;
    }
}

