/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.manager;

import fi.csc.microarray.manager.LogParser;
import fi.csc.microarray.util.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.tools.Server;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class LogImport {
    private JdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert insertJobTemplate;
    private static final String CREATE_JOBS_TABLE = "CREATE TABLE IF NOT EXISTS jobs (id VARCHAR(100) PRIMARY KEY, operation VARCHAR(100), status VARCHAR(20), starttime DATETIME DEFAULT NULL, endtime DATETIME DEFAULT NULL, wallclockTime INT DEFAULT NULL, errorMessage TEXT DEFAULT NULL, outputText TEXT DEFAULT NULL, username VARCHAR(20), compHost VARCHAR(50)); ";

    public LogImport() throws SQLException {
        String dbDriver = "org.h2.Driver";
        String dbUrl = "jdbc:h2:nami-work-files/database/chipster-manager";
        boolean startWebConsole = true;
        String dbUsername = "chipster";
        String dbPassword = "";
        int webConsolePort = 8082;
        DriverManagerDataSource dataSource = new DriverManagerDataSource();
        dataSource.setDriverClassName(dbDriver);
        dataSource.setUrl(dbUrl);
        dataSource.setUsername(dbUsername);
        dataSource.setPassword(dbPassword);
        this.jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        this.insertJobTemplate = new SimpleJdbcInsert((DataSource)dataSource).withTableName("jobs");
        this.jdbcTemplate.execute(CREATE_JOBS_TABLE);
        if (startWebConsole) {
            Server server = Server.createWebServer((String[])new String[]{"-webAllowOthers", "-webPort", String.valueOf(webConsolePort)});
            server.start();
        }
    }

    public void importLog(File logFile, String compHost) throws IOException, ParseException {
        SimpleDateFormat df = new SimpleDateFormat("E MMM d H:m:s z yyyy");
        LogParser parser = new LogParser();
        Iterable<HashMap<String, String>> entries = parser.parse(logFile);
        int success = 0;
        int integrityFailed = 0;
        int usernameFailed = 0;
        int endtimeFailed = 0;
        int failed = 0;
        for (HashMap<String, String> entry : entries) {
            try {
                Date endTime;
                Date startTime = df.parse(entry.get("starttime"));
                if (!entry.get("endtime").equals("null")) {
                    endTime = df.parse(entry.get("endtime"));
                } else {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(startTime);
                    ((Calendar)calendar).add(13, 5);
                    endTime = calendar.getTime();
                    ++endtimeFailed;
                }
                if (entry.get("username").equals("null")) {
                    ++usernameFailed;
                    continue;
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("id", UUID.randomUUID().toString());
                parameters.put("operation", entry.get("operation"));
                parameters.put("status", entry.get("status"));
                parameters.put("starttime", startTime);
                parameters.put("endtime", endTime);
                parameters.put("wallclockTime", (endTime.getTime() - startTime.getTime()) / 1000L);
                parameters.put("errorMessage", null);
                parameters.put("outputText", null);
                parameters.put("username", entry.get("username"));
                parameters.put("compHost", compHost);
                this.insertJobTemplate.execute(parameters);
                ++success;
            }
            catch (DataIntegrityViolationException dive) {
                ++integrityFailed;
            }
            catch (Exception e) {
                System.out.println(e.toString());
                ++failed;
            }
        }
        System.out.println("success: " + success + ", integrity failed: " + integrityFailed + ", username failed: " + usernameFailed + ", endtime failed: " + endtimeFailed + ", other failed: " + failed);
    }

    public static void main(String[] args) throws SQLException, IOException, ConfigurationLoader.OldConfigurationFormatException, ParseException {
    }
}

