/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.frontend;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.auth.AuthenticationProvider;
import fi.csc.microarray.auth.JaasAuthenticationProvider;
import fi.csc.microarray.frontend.AuthorisationException;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.AuthenticationMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.util.MemUtil;
import fi.csc.microarray.util.SecureSessionPool;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class Authenticator
extends NodeBase {
    private static final Logger logger = Logger.getLogger(Authenticator.class);
    private static final Logger securityLogger = Logger.getLogger((String)"security.frontend");
    private static final Logger messageLogger = Logger.getLogger((String)"messages.frontend");
    private SecureSessionPool sessionPool = new SecureSessionPool();
    private MessagingEndpoint endpoint = new MessagingEndpoint(this);
    private MessagingTopic authorisedTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
    private MessagingTopic testTopic;
    private RequestListener requestListener;
    private TestListener testListener;
    private AuthenticationProvider authenticationProvider;

    public Authenticator() throws Exception {
        MessagingTopic requestTopic = this.endpoint.createTopic(Topics.Name.REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        this.requestListener = new RequestListener();
        requestTopic.setListener(this.requestListener);
        this.testTopic = this.endpoint.createTopic(Topics.Name.TEST_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
        this.testListener = new TestListener();
        this.testTopic.setListener(this.testListener);
        this.authenticationProvider = new JaasAuthenticationProvider();
        logger.info((Object)("authenticator is up and running [" + ApplicationConstants.NAMI_VERSION + "]"));
        logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
    }

    public String getName() {
        return "authenticator";
    }

    private class TestListener
    implements MessagingListener {
        private TestListener() {
        }

        public void onNamiMessage(NamiMessage msg) {
            logger.debug((Object)"got message on test-topic.");
            try {
                Destination dest = msg.getReplyTo();
                if (dest != null) {
                    CommandMessage replyMessage = new CommandMessage("OK");
                    Authenticator.this.endpoint.replyToMessage(msg, (NamiMessage)replyMessage);
                } else {
                    logger.debug((Object)"ReplyTo is null, so no reply was sent.");
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private class RequestListener
    implements MessagingListener {
        private static final String KEY_PENDING_MESSAGE = "pending-message";
        private static final String KEY_USERNAME = "username";

        private RequestListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onNamiMessage(NamiMessage msg) {
            try {
                logger.debug((Object)("starting to process " + msg));
                NamiMessage messageToBeRouted = null;
                SecureSessionPool.Session session = null;
                if (msg.getSessionID() != null) {
                    UUID id = UUID.fromString(msg.getSessionID());
                    if (Authenticator.this.sessionPool.getSession(id) != null) {
                        session = Authenticator.this.sessionPool.getSession(id);
                        logger.debug((Object)("message " + msg.getMessageID() + " had a proper session " + session.getID()));
                    }
                }
                if (session == null) {
                    logger.debug((Object)("message " + msg + " has no session, requires authentication"));
                    session = Authenticator.this.sessionPool.createSession();
                    logger.debug((Object)("created new session, pool size is now " + Authenticator.this.sessionPool.size()));
                    session.putParameter(KEY_PENDING_MESSAGE, msg);
                    this.requestAuthentication(msg, session.getID().toString());
                } else {
                    if (msg instanceof AuthenticationMessage) {
                        AuthenticationMessage authMsg = (AuthenticationMessage)msg;
                        if (!authMsg.isLogin()) {
                            if (!authMsg.isLogout()) throw new IllegalArgumentException("unknown authentication message: " + authMsg);
                            logger.debug((Object)("message " + msg.getMessageID() + " is a logout"));
                            Authenticator.this.sessionPool.removeSession(session);
                            return;
                        }
                        messageLogger.debug((Object)("message " + authMsg.getMessageID() + " is a login"));
                        if (!Authenticator.this.authenticationProvider.authenticate(authMsg.getUsername(), authMsg.getPassword().toCharArray())) {
                            securityLogger.info((Object)("illegal username/password (user " + authMsg.getUsername() + ", auth. message JMS id was " + authMsg.getJmsMessageID() + ")"));
                            this.ackLogin(authMsg, session.getID().toString(), false);
                            return;
                        }
                        this.ackLogin(authMsg, session.getID().toString(), true);
                        session.putParameter(KEY_USERNAME, authMsg.getUsername());
                        authMsg.setSessionID(session.getID().toString());
                        securityLogger.info((Object)("authenticated user " + authMsg.getUsername() + " (auth. message JMS id was " + authMsg.getJmsMessageID() + ")"));
                        if (session.getParameter(KEY_PENDING_MESSAGE) != null) {
                            messageToBeRouted = (NamiMessage)session.getParameter(KEY_PENDING_MESSAGE);
                        }
                    } else {
                        messageToBeRouted = msg;
                    }
                    session.touch();
                }
                if (messageToBeRouted == null) return;
                securityLogger.info((Object)("message " + messageToBeRouted.getMessageID() + " was allowed"));
                messageLogger.info((Object)messageToBeRouted);
                messageToBeRouted.setUsername((String)session.getParameter(KEY_USERNAME));
                Authenticator.this.authorisedTopic.sendMessage(messageToBeRouted);
                securityLogger.info((Object)("routing message " + messageToBeRouted.getMessageID() + " to authorised topic"));
                return;
            }
            catch (JMSException e) {
                logger.error((Object)e);
                return;
            }
            catch (AuthorisationException e) {
                securityLogger.info((Object)("authorisation failed: " + e.getMessage()));
                logger.info((Object)e);
            }
        }

        private void ackLogin(NamiMessage loginMessage, String sessionID, boolean succeeded) throws JMSException, AuthorisationException {
            AuthenticationMessage.AuthenticationOperation operation = succeeded ? AuthenticationMessage.AuthenticationOperation.LOGIN_SUCCEEDED : AuthenticationMessage.AuthenticationOperation.LOGIN_FAILED;
            AuthenticationMessage request = new AuthenticationMessage(operation);
            request.setSessionID(sessionID);
            request.setReplyTo(loginMessage.getReplyTo());
            Authenticator.this.endpoint.replyToMessage(loginMessage, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }

        private void requestAuthentication(NamiMessage msg, String sessionID) throws JMSException, AuthorisationException {
            AuthenticationMessage request = new AuthenticationMessage(AuthenticationMessage.AuthenticationOperation.REQUEST);
            request.setSessionID(sessionID);
            request.setReplyTo(msg.getReplyTo());
            logger.debug((Object)("requesting authentication for " + msg.getMessageID() + " under the session " + sessionID));
            Authenticator.this.endpoint.replyToMessage(msg, request, Topics.MultiplexName.AUTHORISE_TO.toString());
        }
    }
}

