/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class ImageViewer
extends Visualisation
implements MouseListener {
    private static final Logger logger = Logger.getLogger(ImageViewer.class);
    private Image original;
    private JScrollPane scroller;
    private boolean isScaledMode = true;
    private ImagePanel imagePanel = new ImagePanel();
    private static final Cursor ZOOM_IN_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(VisualConstants.ZOOM_IN_CURSOR_IMAGE.getImage(), new Point(5, 2), "ZoomIn");
    private static final Cursor ZOOM_OUT_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(VisualConstants.ZOOM_OUT_CURSOR_IMAGE.getImage(), new Point(5, 2), "ZoomOut");

    public ImageViewer(VisualisationFrame frame) {
        super(frame);
        this.imagePanel.addMouseListener(this);
    }

    private double calculateScale() {
        double yScale;
        Dimension targetSize = this.scroller.getViewport().getExtentSize();
        double xScale = targetSize.getWidth() / (double)this.original.getWidth(null);
        return xScale < (yScale = targetSize.getHeight() / (double)this.original.getHeight(null)) ? xScale : yScale;
    }

    private Dimension calculateSize() {
        double scale = this.calculateScale();
        if (scale >= 1.0 || !this.isScaledMode) {
            scale = 1.0;
            this.isScaledMode = false;
        }
        return new Dimension((int)((double)this.original.getWidth(null) * scale), (int)((double)this.original.getHeight(null) * scale));
    }

    private void updateCursor() {
        if (this.calculateScale() < 1.0) {
            if (this.isScaledMode) {
                logger.debug((Object)"Zoom in cursor");
                this.imagePanel.setCursor(ZOOM_IN_CURSOR);
            } else {
                logger.debug((Object)"Zoom out cursor");
                this.imagePanel.setCursor(ZOOM_OUT_CURSOR);
            }
        } else {
            this.isScaledMode = false;
            logger.debug((Object)"Null cursor");
            this.imagePanel.setCursor(null);
        }
    }

    public void mouseClicked(MouseEvent e) {
        logger.debug((Object)("mouse clicked: " + e));
        if (this.calculateScale() < 1.0) {
            this.isScaledMode = !this.isScaledMode;
        }
        this.updateCursor();
        this.imagePanel.setPreferredSize(this.calculateSize());
        this.imagePanel.setSize(this.calculateSize());
        logger.debug((Object)("isScaledMode: " + this.isScaledMode));
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        byte[] bytes = data.getContents();
        if (bytes != null) {
            this.original = new ImageIcon(bytes).getImage();
            this.scroller = new JScrollPane();
            this.scroller.setViewportView(this.imagePanel);
            this.scroller.setBorder(BorderFactory.createEmptyBorder());
            this.isScaledMode = true;
            return this.scroller;
        }
        return this.getDefaultVisualisation();
    }

    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        return bean.isContentTypeCompatitible("image/jpeg", "image/png", "image/gif");
    }

    private class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension size = ImageViewer.this.calculateSize();
            ImageViewer.this.updateCursor();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(ImageViewer.this.original, 0, 0, (int)size.getWidth(), (int)size.getHeight(), null);
        }
    }
}

