/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import com.jgoodies.looks.HeaderStyle;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.ToolBarComponentFactory;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.visualisation.ComboBoxRenderer;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationToolBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(VisualisationToolBar.class);
    public static final int PANEL_WIDTH = 310;
    public boolean isMaximised = false;
    private ClientApplication application = Session.getSession().getApplication();
    private JButton redrawButton = ToolBarComponentFactory.createButton("Redraw", VisualConstants.REDRAW_ICON, true, false);
    private JButton helpButton = ToolBarComponentFactory.createButton("Help", VisualConstants.QUESTION_MARK_ICON, true, false);
    private JButton maximiseButton = ToolBarComponentFactory.createButton("Maximise", VisualConstants.MAXIMISE_ICON, true, false);
    private JButton splitButton = ToolBarComponentFactory.createButton("Duplicate", VisualConstants.SPLIT_ICON, true, false);
    private JButton detachButton = ToolBarComponentFactory.createButton("Detach", VisualConstants.TO_WINDOW_ICON, true, false);
    private JComboBox methodChoiceBox = ToolBarComponentFactory.createComboBox();
    private String helpAddress;
    private boolean userComboAction;
    private boolean isSplit;

    public VisualisationToolBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.setFloatable(false);
        this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
        Dimension ZERO_SIZE = new Dimension(0, 0);
        this.redrawButton.setMinimumSize((Dimension)ZERO_SIZE.clone());
        this.helpButton.setMinimumSize((Dimension)ZERO_SIZE.clone());
        this.maximiseButton.setMinimumSize((Dimension)ZERO_SIZE.clone());
        this.splitButton.setMinimumSize((Dimension)ZERO_SIZE.clone());
        this.detachButton.setMinimumSize((Dimension)ZERO_SIZE.clone());
        this.methodChoiceBox.setBackground(Color.WHITE);
        this.methodChoiceBox.addActionListener(this);
        this.methodChoiceBox.setRenderer(new ComboBoxRenderer());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 4));
        buttonPanel.setOpaque(false);
        buttonPanel.add(this.helpButton);
        buttonPanel.add(this.redrawButton);
        buttonPanel.add(this.maximiseButton);
        buttonPanel.add(this.detachButton);
        JLabel titleLabel = new JLabel("Method: ");
        this.add(titleLabel);
        this.add(this.methodChoiceBox);
        this.add(Box.createHorizontalStrut(3));
        this.add(Box.createHorizontalGlue());
        this.add(buttonPanel);
        this.redrawButton.setEnabled(false);
        this.redrawButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.maximiseButton.addActionListener(this);
        this.splitButton.addActionListener(this);
        this.detachButton.addActionListener(this);
        this.helpButton.setVisible(false);
        this.refreshVisualisationList(VisualisationMethod.NONE, null);
        this.application.addPropertyChangeListener(this);
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.methodChoiceBox);
        return order;
    }

    public void setHelpAddress(String helpAddress) {
        this.helpAddress = helpAddress;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualisationToolBar.this.helpButton.setVisible(VisualisationToolBar.this.helpAddress != null);
                VisualisationToolBar.this.repaint();
            }
        });
    }

    private void refreshVisualisationList(VisualisationMethod method, List<DataBean> datas) {
        this.maximiseButton.setEnabled(datas != null && datas.size() > 0);
        this.fillMethodsFor(datas);
        this.methodChoiceBox.setEnabled(datas != null && datas.size() > 0);
        this.redrawButton.setEnabled(method != VisualisationMethod.NONE);
        this.splitButton.setEnabled(method != VisualisationMethod.NONE || this.isSplit);
        this.detachButton.setEnabled(method != VisualisationMethod.NONE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.application.getVisualisationFrameManager() == null) {
            return;
        }
        VisualisationFrame visualisation = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN);
        if (source == this.methodChoiceBox) {
            if (this.userComboAction) {
                VisualisationMethod method = (VisualisationMethod)((Object)this.methodChoiceBox.getSelectedItem());
                if (method == null) {
                    method = VisualisationMethod.NONE;
                }
                if (visualisation.getMethod() != method) {
                    this.application.setVisualisationMethod(method, null, this.application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                }
                this.redrawButton.setEnabled(method != VisualisationMethod.NONE);
            }
        } else if (source == this.maximiseButton) {
            this.maximiseOrRestoreVisualisation();
        } else if (source == this.redrawButton) {
            this.application.setVisualisationMethod(visualisation.getMethod(), visualisation.getVariables(), visualisation.getDatas(), visualisation.getType());
        } else if (source == this.helpButton) {
            this.viewHelp();
        } else if (source == this.splitButton) {
            this.split();
        } else if (source == this.detachButton) {
            this.detach();
        }
    }

    public void maximiseOrRestoreVisualisation() {
        this.isMaximised = !this.isMaximised;
        this.application.setMaximisedVisualisationMode(this.isMaximised);
        this.maximiseButton.setText(this.getMaximiseButtonText());
        this.maximiseButton.setIcon(this.getMaximiseButtonIcon());
    }

    public Icon getMaximiseButtonIcon() {
        return this.isMaximised ? VisualConstants.RESTORE_ICON : VisualConstants.MAXIMISE_ICON;
    }

    public String getMaximiseButtonText() {
        return this.isMaximised ? "Restore" : "Maximise";
    }

    public void viewHelp() {
        this.application.viewHelp(this.helpAddress);
    }

    public void detach() {
        VisualisationFrame visualisation = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN);
        this.application.setVisualisationMethod(visualisation.getMethod(), visualisation.getVariables(), visualisation.getDatas(), VisualisationFrameManager.FrameType.WINDOW);
    }

    public void split() {
        VisualisationFrame visualisation = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN);
        this.isSplit = !this.isSplit;
        if (this.isSplit) {
            this.application.setVisualisationMethod(visualisation.getMethod(), visualisation.getVariables(), visualisation.getDatas(), VisualisationFrameManager.FrameType.SIDE);
        } else {
            this.application.getVisualisationFrameManager().closeAllByType(VisualisationFrameManager.FrameType.SIDE);
            this.splitButton.setEnabled(!this.methodChoiceBox.getSelectedItem().equals((Object)VisualisationMethod.NONE));
        }
        this.splitButton.setText(this.getSplitText());
        this.splitButton.setIcon(this.getSplitIcon());
    }

    public String getSplitText() {
        return this.isSplit ? "Close second" : "Duplicate";
    }

    public Icon getSplitIcon() {
        return this.isSplit ? VisualConstants.CLOSE_ICON : VisualConstants.SPLIT_ICON;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event instanceof VisualisationMethodChangedEvent) {
            VisualisationMethodChangedEvent e = (VisualisationMethodChangedEvent)event;
            if (e.getTarget() == VisualisationFrameManager.FrameType.MAIN) {
                if (e.getNewMethod() == VisualisationMethod.PHENODATA) {
                    this.setHelpAddress("chipster-manual/visualisation-phenodata.html");
                } else {
                    this.setHelpAddress(null);
                }
                this.refreshVisualisationList(e.getNewMethod(), e.getDatas());
                try {
                    if (e.getNewMethod() != null) {
                        logger.debug((Object)("updating GUI to method " + (Object)((Object)e.getNewMethod())));
                        this.userComboAction = false;
                        this.methodChoiceBox.setSelectedItem((Object)e.getNewMethod());
                        this.userComboAction = true;
                        this.methodChoiceBox.repaint();
                    }
                }
                catch (Exception exc) {
                    this.application.reportException(exc);
                }
            }
        } else if (event instanceof DatasetChoiceEvent) {
            List<DataBean> currentDatas = this.application.getSelectionManager().getSelectedDataBeans();
            List<DataBean> newDatas = this.application.getVisualisationFrameManager().getFrame(VisualisationFrameManager.FrameType.MAIN).getDatas();
            if (currentDatas == null || newDatas == null || !currentDatas.containsAll(newDatas) || !newDatas.containsAll(currentDatas)) {
                this.application.setVisualisationMethod(VisualisationMethod.NONE, null, this.application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
                this.refreshVisualisationList(VisualisationMethod.NONE, this.application.getSelectionManager().getSelectedDataBeans());
            }
        }
    }

    public void fillMethodsFor(List<DataBean> datas) {
        ArrayList<VisualisationMethod> applicableVisualisations = new ArrayList<VisualisationMethod>();
        applicableVisualisations.addAll(Arrays.asList(VisualisationMethod.values()));
        ArrayList<VisualisationMethod> onlyNoneList = new ArrayList<VisualisationMethod>();
        onlyNoneList.add(VisualisationMethod.NONE);
        if (datas != null) {
            for (VisualisationMethod method : VisualisationMethod.values()) {
                try {
                    if (datas.size() == 1) {
                        if (method.isApplicableTo(datas.get(0))) continue;
                        applicableVisualisations.remove((Object)method);
                        continue;
                    }
                    if (method.isApplicableTo(datas)) continue;
                    applicableVisualisations.remove((Object)method);
                }
                catch (Exception e) {
                    this.application.reportException(new MicroarrayException("Unable to check applicable visualisations for the dataset", e));
                    applicableVisualisations = onlyNoneList;
                    break;
                }
            }
            this.userComboAction = false;
            this.methodChoiceBox.removeAllItems();
            Visualisation.fillCompoBox(this.methodChoiceBox, applicableVisualisations.toArray());
            this.userComboAction = true;
        } else {
            applicableVisualisations = onlyNoneList;
            this.userComboAction = false;
            this.methodChoiceBox.removeAllItems();
            Visualisation.fillCompoBox(this.methodChoiceBox, applicableVisualisations.toArray());
            this.userComboAction = true;
        }
    }
}

