/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation;

import com.jgoodies.uif_lite.panel.SimpleInternalFrame;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.operation.ExecutionItem;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationCategory;
import fi.csc.microarray.client.operation.OperationChoicePanel;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.ParameterPanel;
import fi.csc.microarray.client.selection.DatasetChoiceEvent;
import fi.csc.microarray.client.tasks.TaskException;
import fi.csc.microarray.description.VVSADLParser;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final String OPERATION_LIST_TITLE = "Analysis tools";
    private static final String SHOW_PARAMETERS_TEXT = "Show parameters";
    private static final String HIDE_PARAMETERS_TEXT = "Hide parameters";
    private static final String OPERATIONS = "Operations";
    private static final String PARAMETERS = "Parameters";
    private static final Logger logger = Logger.getLogger(OperationPanel.class);
    private static final int WHOLE_PANEL_HEIGHT = 240;
    private static final int WHOLE_PANEL_WIDTH = 660;
    private OperationChoicePanel operationChoicePanel = null;
    private JPanel cardPanel = new JPanel();
    private JTextArea detailField = new JTextArea();
    private JLabel suitabilityLabel = new JLabel();
    private JButton sourceButton = new JButton("Show tool sourcecode");
    private JButton helpButton = new JButton("More help");
    private JButton parametersButton = new JButton();
    private JButton executeButton = new JButton();
    private JScrollPane detailFieldScroller;
    private boolean isParametersVisible = false;
    private ExecutionItem chosenOperation = null;
    private ClientApplication application = Session.getSession().getApplication();

    public OperationPanel(Collection<OperationCategory> parsedCategories) throws VVSADLParser.ParseException {
        super(new GridBagLayout());
        this.setPreferredSize(new Dimension(660, 240));
        this.setMinimumSize(new Dimension(0, 0));
        this.operationChoicePanel = new OperationChoicePanel(this, parsedCategories);
        this.cardPanel = new JPanel(new CardLayout());
        this.detailField.setEditable(false);
        this.detailField.setLineWrap(true);
        this.detailField.setWrapStyleWord(true);
        this.detailFieldScroller = new JScrollPane(this.detailField);
        this.detailFieldScroller.setHorizontalScrollBarPolicy(31);
        this.sourceButton.setEnabled(false);
        this.sourceButton.setToolTipText("View Source Code");
        this.sourceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    OperationPanel.this.application.showSourceFor(VVSADLParser.generateOperationIdentifier(OperationPanel.this.chosenOperation.getCategoryName(), OperationPanel.this.chosenOperation.getName()));
                }
                catch (TaskException je) {
                    OperationPanel.this.application.reportException(je);
                }
            }
        });
        this.helpButton.setEnabled(false);
        this.helpButton.setToolTipText("More information about this tool");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OperationDefinition od = OperationPanel.this.chosenOperation instanceof OperationDefinition ? (OperationDefinition)OperationPanel.this.chosenOperation : ((Operation)OperationPanel.this.chosenOperation).getDefinition();
                OperationPanel.this.application.viewHelpFor(od);
            }
        });
        this.parametersButton.addActionListener(this);
        this.parametersButton.setEnabled(false);
        this.parametersButton.setText(SHOW_PARAMETERS_TEXT);
        this.suitabilityLabel.setPreferredSize(new Dimension(VisualConstants.INCOMPATIBLE_ICON.getIconHeight(), VisualConstants.INCOMPATIBLE_ICON.getIconHeight()));
        this.executeButton.setIcon(VisualConstants.DOUBLE_FORWARD_ICON);
        this.executeButton.setDisabledIcon(VisualConstants.DOUBLE_FORWARD_BW_ICON);
        this.executeButton.setText("<html><b>Run</b></html>");
        this.executeButton.setHorizontalAlignment(0);
        this.executeButton.setHorizontalTextPosition(2);
        this.executeButton.setToolTipText("Run selected operation for selected datasets");
        this.executeButton.addActionListener(this);
        this.executeButton.setName("executeButton");
        this.setExecuteButtonEnabled(false);
        this.detailFieldScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, VisualConstants.OPERATION_LIST_BORDER_COLOR));
        this.cardPanel.add((Component)this.operationChoicePanel, OPERATIONS);
        JPanel topLeftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets.set(0, 10, 0, 10);
        topLeftPanel.add((Component)this.suitabilityLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets.set(0, 0, 0, 0);
        topLeftPanel.add((Component)this.parametersButton, c);
        JPanel topPanel = new JPanel(new GridLayout(1, 2));
        topPanel.add(topLeftPanel);
        topPanel.add(this.executeButton);
        JPanel bottomPanel = new JPanel(new GridLayout(1, 2));
        bottomPanel.add(this.helpButton);
        bottomPanel.add(this.sourceButton);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets.set(0, 0, 0, 0);
        this.add((Component)this.cardPanel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)topPanel, c);
        c.gridx = 1;
        ++c.gridy;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)this.detailFieldScroller, c);
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)bottomPanel, c);
        Session.getSession().getApplication().addPropertyChangeListener(this);
    }

    public Vector<Component> getFocusComponents() {
        Vector<Component> order = new Vector<Component>();
        order.addAll(this.operationChoicePanel.getFocusComponents());
        order.add(this.executeButton);
        return order;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.parametersButton) {
            this.parametersButtonClicked();
        } else if (e.getSource() == this.executeButton) {
            if (this.chosenOperation instanceof OperationDefinition) {
                this.application.executeOperation((OperationDefinition)this.chosenOperation, null);
            } else {
                try {
                    Operation clonedOperation = new Operation((Operation)this.chosenOperation);
                    this.application.executeOperation(clonedOperation);
                }
                catch (MicroarrayException me) {
                    throw new RuntimeException(me);
                }
            }
        }
    }

    private void parametersButtonClicked() {
        if (!this.isParametersVisible) {
            this.showParameterPanel();
        } else {
            this.showOperationsPanel();
        }
    }

    private void setExecuteButtonEnabled(boolean enabled) {
        if (enabled) {
            this.executeButton.setEnabled(true);
        } else {
            this.executeButton.setEnabled(false);
        }
    }

    private void showParameterPanel() {
        this.showParametersTitle(true);
        this.parametersButton.setText(HIDE_PARAMETERS_TEXT);
        try {
            if (this.chosenOperation instanceof Operation) {
                this.chosenOperation = (Operation)this.chosenOperation;
            } else if (this.chosenOperation instanceof OperationDefinition) {
                this.chosenOperation = new Operation((OperationDefinition)this.chosenOperation, this.application.getSelectionManager().getSelectedDatasAsArray());
            } else {
                throw new RuntimeException("wrong type: " + this.chosenOperation.getClass().getSimpleName());
            }
            this.cardPanel.add((Component)new ParameterPanel((Operation)this.chosenOperation, this), PARAMETERS);
            CardLayout cl = (CardLayout)this.cardPanel.getLayout();
            cl.show(this.cardPanel, PARAMETERS);
            this.isParametersVisible = true;
        }
        catch (MicroarrayException e) {
            this.application.reportException(e);
        }
    }

    private void showOperationsPanel() {
        this.showParametersTitle(false);
        this.parametersButton.setText(SHOW_PARAMETERS_TEXT);
        CardLayout cl = (CardLayout)this.cardPanel.getLayout();
        cl.show(this.cardPanel, OPERATIONS);
        this.isParametersVisible = false;
    }

    private void showParametersTitle(boolean showParametersTitle) {
        String title = showParametersTitle ? "Analysis tools - " + this.chosenOperation.getCategoryName() + " [" + this.chosenOperation.getName() + "]" : OPERATION_LIST_TITLE;
        ((SimpleInternalFrame)this.getParent()).setTitle(title);
        this.repaint();
    }

    public void selectOperation(ExecutionItem operation) {
        this.chosenOperation = operation;
        this.showParametersTitle(false);
        this.showOperationInfoText();
        if (operation != null) {
            this.parametersButton.setEnabled(true);
            OperationDefinition.Suitability suitability = this.evaluateSuitability();
            if (suitability.isImpossible()) {
                this.makeButtonsEnabled(false);
            } else {
                this.makeButtonsEnabled(true);
            }
            if (suitability.isImpossible()) {
                this.suitabilityLabel.setIcon(VisualConstants.INCOMPATIBLE_ICON);
            } else if (suitability.isOk()) {
                this.suitabilityLabel.setIcon(VisualConstants.SUITABLE_ICON);
            } else if (suitability.isImpossible()) {
                this.suitabilityLabel.setIcon(VisualConstants.SUITABILITY_WARNING_ICON);
            }
            this.suitabilityLabel.setToolTipText(" " + suitability.toString());
        } else {
            this.makeButtonsEnabled(false);
            this.parametersButton.setEnabled(false);
            this.suitabilityLabel.setIcon(null);
            this.suitabilityLabel.setToolTipText("");
        }
    }

    public void setInfoText(String text, Color color, boolean enable) {
        this.detailField.setForeground(color);
        this.detailField.setText(text);
        this.updateDetailFieldMargin();
    }

    public void showOperationInfoText() {
        if (this.chosenOperation != null) {
            this.setInfoText(this.chosenOperation.getDescription(), Color.BLACK, true);
            this.sourceButton.setEnabled(true);
            this.helpButton.setEnabled(true);
        } else {
            this.setInfoText("", Color.BLACK, false);
            this.sourceButton.setEnabled(false);
            this.helpButton.setEnabled(false);
        }
    }

    private void updateDetailFieldMargin() {
        if (this.detailFieldScroller.getVerticalScrollBar().isVisible()) {
            logger.debug((Object)"vertical scrollbar is visible");
            this.detailField.setMargin(new Insets(2, 2, 2, 2 + this.detailFieldScroller.getVerticalScrollBar().getWidth()));
        } else {
            logger.debug((Object)"vertical scrollbar is not visible");
            this.detailField.setMargin(new Insets(2, 2, 2, 2));
        }
    }

    public void enableAction(boolean enabled) {
        if (!this.evaluateSuitability().isImpossible()) {
            this.makeButtonsEnabled(enabled);
        }
        if (!enabled) {
            this.suitabilityLabel.setIcon(null);
        }
    }

    private void makeButtonsEnabled(boolean enabled) {
        if (!enabled) {
            this.showOperationsPanel();
        }
        this.setExecuteButtonEnabled(enabled);
    }

    @Override
    public void propertyChange(PropertyChangeEvent dataEvent) {
        if (dataEvent instanceof DatasetChoiceEvent) {
            logger.debug((Object)("chosen data " + this.application.getSelectionManager().getSelectedDataBean() + " (possible one among many)"));
            if (this.application.getSelectionManager().getSelectedDataBean() != null) {
                this.showOperationsPanel();
            }
        }
    }

    private OperationDefinition.Suitability evaluateSuitability() {
        if (this.chosenOperation == null) {
            return OperationDefinition.Suitability.IMPOSSIBLE;
        }
        return this.chosenOperation.evaluateSuitabilityFor(this.application.getSelectionManager().getSelectedDataBeans());
    }
}

