/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser;

import fi.csc.microarray.ApplicationConstants;
import fi.csc.microarray.MicroarrayConfiguration;
import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisDescriptionRepository;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ProcessPool;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.MemUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class AnalyserServer
extends MonitoredNodeBase
implements MessagingListener,
ResultCallback {
    private static int RECEIVE_TIMEOUT = Integer.parseInt(MicroarrayConfiguration.getValue("analyser", "receive_timeout"));
    private static int SCHEDULE_TIMEOUT = Integer.parseInt(MicroarrayConfiguration.getValue("analyser", "schedule_timeout"));
    private static int TIMEOUT_CHECK_INTERVAL = Integer.parseInt(MicroarrayConfiguration.getValue("analyser", "timeout_check_interval"));
    public static final String DESCRIPTION_OUTPUT_NAME = "description";
    public static final String SOURCECODE_OUTPUT_NAME = "sourcecode";
    private static final Logger logger = Logger.getLogger(AnalyserServer.class);
    private static final Logger loggerJobs = Logger.getLogger((String)"jobs");
    private static final Logger loggerStatus = Logger.getLogger((String)"status");
    private static final String workDirBase = MicroarrayConfiguration.getValue("analyser", "work_dir");
    private static final boolean sweepWorkDir = "true".equals(MicroarrayConfiguration.getValue("analyser", "sweep_work_dir").trim());
    private static final String customScriptsDirName = MicroarrayConfiguration.getValue("analyser", "customScriptsDir");
    private String id = UUID.randomUUID().toString();
    private File workDir;
    private AnalysisDescriptionRepository descriptionRepository = new AnalysisDescriptionRepository();
    private HashSet<String> supportedOperations = new HashSet();
    private MessagingEndpoint endpoint;
    private MessagingTopic managerTopic;
    private ExecutorService executorService;
    private ProcessPool processPool;
    private int maxJobs = Integer.parseInt(MicroarrayConfiguration.getValue("analyser", "max_jobs"));
    private Object jobsLock = new Object();
    private LinkedHashMap<String, AnalysisJob> receivedJobs = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisJob> scheduledJobs = new LinkedHashMap();
    private LinkedHashMap<String, AnalysisJob> runningJobs = new LinkedHashMap();
    Timer timeoutTimer;

    public AnalyserServer() throws JMSException, IOException, MicroarrayException {
        String[] excludedOperationsList;
        logger.info((Object)"Starting analyser server...");
        if (!this.initWorkDir()) {
            String message = "could not initialize working directory: " + workDirBase + File.pathSeparator + this.id;
            logger.fatal((Object)message);
            throw new IOException(message);
        }
        File customScripts = new File(customScriptsDirName);
        if (!customScripts.exists()) {
            if (customScripts.mkdirs()) {
                logger.debug((Object)("Created custom scripts dir: " + customScripts.toString()));
            } else {
                logger.warn((Object)("Could not create custom scripts dir: " + customScripts.toString()));
            }
        }
        this.executorService = Executors.newCachedThreadPool();
        for (String analysisHandler : MicroarrayConfiguration.getValues("analyser", "analysis_handlers")) {
            try {
                AnalysisHandler handler = (AnalysisHandler)Class.forName(analysisHandler).newInstance();
                this.descriptionRepository.addAnalysisHandler(handler);
                logger.debug((Object)("initialised handler " + analysisHandler));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        ArrayList<String> allOperations = new ArrayList<String>();
        String[] configOperations = MicroarrayConfiguration.getValues("analyser", "operations");
        allOperations.addAll(Arrays.asList(configOperations));
        for (File f : Files.listFilesRecursively(customScripts)) {
            allOperations.add(f.getAbsolutePath().replace(customScripts.getAbsolutePath(), ""));
        }
        if (allOperations != null) {
            for (String operation : allOperations) {
                this.descriptionRepository.loadOperation(operation, false);
            }
        } else {
            logger.error((Object)"No operations found on the configuration file.");
        }
        String[] allHiddenOperations = MicroarrayConfiguration.getValues("analyser", "hidden-operations");
        if (allHiddenOperations != null) {
            for (String operation : allHiddenOperations) {
                this.descriptionRepository.loadOperation(operation, true);
            }
        }
        HashSet<String> excludedOperations = new HashSet<String>();
        HashSet<String> hiddenOperations = new HashSet<String>();
        String[] includedOperations = MicroarrayConfiguration.getValues("analyser", "includeOperations");
        if (includedOperations == null) {
            logger.debug((Object)"No includeOperations section, including all operations.");
            includedOperations = allOperations.toArray(new String[allOperations.size()]);
        }
        if ((excludedOperationsList = MicroarrayConfiguration.getValues("analyser", "excludeOperations")) != null) {
            for (String value : excludedOperationsList) {
                excludedOperations.add(value);
            }
            logger.debug((Object)("Excluded operations: " + excludedOperations.toString()));
        } else {
            logger.debug((Object)"No excludeOperations section.");
        }
        String[] hiddenOperationsList = MicroarrayConfiguration.getValues("analyser", "hidden-operations");
        if (hiddenOperationsList != null) {
            for (String value : hiddenOperationsList) {
                hiddenOperations.add(value);
            }
        }
        for (String operation : includedOperations) {
            if (excludedOperations.contains(operation)) continue;
            this.supportedOperations.add(operation);
        }
        if (hiddenOperationsList != null) {
            for (String operation : hiddenOperationsList) {
                if (excludedOperations.contains(operation)) continue;
                this.supportedOperations.add(operation);
            }
        }
        this.processPool = new ProcessPool(this.getWorkDir());
        this.timeoutTimer = new Timer(true);
        this.timeoutTimer.schedule((TimerTask)new TimeoutTimerTask(), TIMEOUT_CHECK_INTERVAL, (long)TIMEOUT_CHECK_INTERVAL);
        this.endpoint = new MessagingEndpoint(this);
        MessagingTopic analyseTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        analyseTopic.setListener(this);
        this.managerTopic = this.endpoint.createTopic(Topics.Name.MANAGER_TOPIC, MessagingTopic.AccessMode.WRITE);
        logger.info((Object)("analyser is up and running [" + ApplicationConstants.NAMI_VERSION + "]"));
        logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
    }

    public String getName() {
        return "analyser";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNamiMessage(NamiMessage namiMessage) {
        if (namiMessage instanceof JobMessage) {
            JobMessage jobMessage = (JobMessage)namiMessage;
            if ("describe".equals(jobMessage.getAnalysisId())) {
                logger.info((Object)"sending all descriptions");
                this.sendReplyMessage(jobMessage, this.createDescriptionsMessage(jobMessage));
                return;
            }
            if ("describe-operation".equals(jobMessage.getAnalysisId())) {
                this.sendReplyMessage(jobMessage, this.createSourceCodeMessage(jobMessage));
                return;
            }
            this.receiveJob(jobMessage);
        } else if (namiMessage instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)namiMessage;
            if ("choose".equals(commandMessage.getCommand())) {
                String acceptedId = commandMessage.getNamedParameter("as-id");
                String jobId = commandMessage.getNamedParameter("job-id");
                logger.debug((Object)("ACCEPT_OFFER for analyser: " + acceptedId + " job: " + jobId));
                if (this.id.equals(acceptedId)) {
                    Object object = this.jobsLock;
                    synchronized (object) {
                        AnalysisJob job = this.scheduledJobs.get(commandMessage.getNamedParameter("job-id"));
                        if (job != null) {
                            this.scheduledJobs.remove(jobId);
                            this.runningJobs.put(job.getId(), job);
                            this.executorService.execute(job);
                            logger.info((Object)("Executing job " + job.getId()));
                        } else {
                            logger.warn((Object)"Got ACCEPT_OFFER for job which is not scheduled.");
                        }
                    }
                } else {
                    logger.debug((Object)("Removing scheduled job " + jobId));
                    Object object = this.jobsLock;
                    synchronized (object) {
                        AnalysisJob jobToBeForgotten = (AnalysisJob)this.receivedJobs.remove(jobId);
                        if (jobToBeForgotten != null) {
                            this.receivedJobs.remove(jobToBeForgotten);
                        } else {
                            this.scheduledJobs.remove(jobId);
                            this.activeJobRemoved();
                        }
                    }
                }
            } else if ("cancel".equals(commandMessage.getCommand())) {
                AnalysisJob job;
                String jobId = commandMessage.getParameters().get(0);
                Object object = this.jobsLock;
                synchronized (object) {
                    job = this.receivedJobs.containsKey(jobId) ? (AnalysisJob)this.receivedJobs.remove(jobId) : (this.scheduledJobs.containsKey(jobId) ? (AnalysisJob)this.scheduledJobs.remove(jobId) : this.runningJobs.get(jobId));
                }
                if (job != null) {
                    job.cancel();
                }
            }
            this.updateStatus();
        } else {
            logger.error((Object)("unidentified message: " + namiMessage.getMessageID()));
        }
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public boolean shouldSweepWorkDir() {
        return sweepWorkDir;
    }

    public ProcessPool getProcessPool() {
        return this.processPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunningJob(AnalysisJob job) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            logger.warn((Object)"Could not get local hostname.");
            hostname = "";
        }
        char delimiter = ';';
        loggerJobs.info((Object)(job.getId() + delimiter + job.getInputMessage().getAnalysisId().replaceAll("\"", "") + delimiter + (Object)((Object)job.getState()) + delimiter + job.getInputMessage().getUsername() + delimiter + job.getExecutionStartTime().toString() + delimiter + job.getExecutionEndTime().toString() + delimiter + hostname));
        logger.debug((Object)("Analyser server removing job " + job.getId() + "(" + (Object)((Object)job.getState()) + ")"));
        Object object = this.jobsLock;
        synchronized (object) {
            this.runningJobs.remove(job.getId());
        }
        this.activeJobRemoved();
        this.sendJobLogMessage(job);
    }

    public void sendJobLogMessage(AnalysisJob job) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            logger.warn((Object)"Could not get local hostname.");
            hostname = "";
        }
        JobLogMessage jobLogMessage = new JobLogMessage(job.getInputMessage().getAnalysisId().replaceAll("\"", ""), job.getState(), job.getId(), job.getExecutionStartTime(), job.getExecutionEndTime(), job.getResultMessage().getErrorMessage(), job.getResultMessage().getOutputText(), job.getInputMessage().getUsername(), hostname);
        try {
            this.managerTopic.sendMessage(jobLogMessage);
        }
        catch (JMSException e) {
            logger.error((Object)"Could not send job log message.", (Throwable)e);
        }
    }

    public void sendResultMessage(NamiMessage original, ResultMessage reply) {
        try {
            this.endpoint.replyToMessage(original, (NamiMessage)reply);
        }
        catch (JMSException e) {
            logger.error((Object)("Could not send ResultMessage " + reply.getMessageID()));
        }
        logger.info((Object)("result message sent (" + reply.getMessageID() + " " + (Object)((Object)reply.getState()) + ")"));
    }

    private void sendReplyMessage(final NamiMessage original, final NamiMessage reply) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    AnalyserServer.this.endpoint.replyToMessage(original, reply);
                }
                catch (JMSException e) {
                    logger.error((Object)"Could not send message.", (Throwable)e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeJobRemoved() {
        Object object = this.jobsLock;
        synchronized (object) {
            if (!this.receivedJobs.isEmpty() && this.runningJobs.size() + this.scheduledJobs.size() < this.maxJobs) {
                AnalysisJob job = this.receivedJobs.values().iterator().next();
                this.receivedJobs.remove(job.getId());
                this.scheduleJob(job);
            }
            this.updateStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveJob(JobMessage jobMessage) {
        AnalysisDescription description = null;
        try {
            description = this.descriptionRepository.getDescription(jobMessage.getAnalysisId());
        }
        catch (AnalysisException e) {
            logger.warn((Object)("Could not fetch description for " + jobMessage.getAnalysisId()));
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Could not load operation.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        if (description == null) {
            logger.info((Object)("Analysis " + jobMessage.getAnalysisId() + " not found."));
            ResultMessage resultMessage = new ResultMessage("", JobState.ERROR, "", "Operation not found.", "", jobMessage.getReplyTo());
            this.sendReplyMessage(jobMessage, resultMessage);
            return;
        }
        if (!this.supportedOperations.contains(description.getSourceResourceName())) {
            logger.debug((Object)("Analysis " + jobMessage.getAnalysisId() + " ( " + description.getSourceResourceName() + " ) not supported, ignoring request."));
            return;
        }
        AnalysisJob job = description.createAnalysisJob(jobMessage, this);
        Object object = this.jobsLock;
        synchronized (object) {
            job.setReceiveTime(new Date());
            if (this.runningJobs.size() + this.scheduledJobs.size() < this.maxJobs) {
                this.scheduleJob(job);
            } else {
                this.receivedJobs.put(job.getId(), job);
                try {
                    this.sendAckMessage(job);
                }
                catch (Exception e) {
                    this.receivedJobs.remove(job.getId());
                    logger.error((Object)("Could not send ACK for job " + job.getId()));
                }
            }
        }
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob(AnalysisJob job) {
        Object object = this.jobsLock;
        synchronized (object) {
            job.setScheduleTime(new Date());
            this.scheduledJobs.put(job.getId(), job);
        }
        try {
            this.sendOfferMessage(job);
        }
        catch (Exception e) {
            Object object2 = this.jobsLock;
            synchronized (object2) {
                this.scheduledJobs.remove(job.getId());
            }
            logger.error((Object)("Could not send OFFER for job " + job.getId()));
        }
        this.updateStatus();
    }

    private void sendAckMessage(AnalysisJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("acknowledge");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        this.sendReplyMessage(job.getInputMessage(), offerMessage);
    }

    private void sendOfferMessage(AnalysisJob job) throws JMSException {
        CommandMessage offerMessage = new CommandMessage("offer");
        offerMessage.addNamedParameter("as-id", this.id);
        offerMessage.addNamedParameter("job-id", job.getId());
        this.sendReplyMessage(job.getInputMessage(), offerMessage);
    }

    private ResultMessage createDescriptionsMessage(JobMessage requestMessage) {
        ResultMessage resultMessage = new ResultMessage("", JobState.COMPLETED, "", "", "", requestMessage.getReplyTo());
        try {
            String description = this.descriptionRepository.serialiseAsStringBuffer().toString();
            resultMessage.addPayload(DESCRIPTION_OUTPUT_NAME, new ByteArrayInputStream(description.getBytes()));
        }
        catch (JMSException e) {
            logger.error((Object)"Could not send analysis descriptions", (Throwable)e);
            resultMessage.setState(JobState.ERROR);
            resultMessage.setErrorMessage("Could not send analysis descriptions.");
        }
        return resultMessage;
    }

    private ResultMessage createSourceCodeMessage(JobMessage requestMessage) {
        ResultMessage resultMessage = new ResultMessage("", JobState.COMPLETED, "", "", "", requestMessage.getReplyTo());
        try {
            String name = new String(requestMessage.getParameters().get(0));
            logger.info((Object)("sending source code for " + name));
            String sourceCode = this.descriptionRepository.getDescription(name).getSourceCode();
            byte[] bytes = sourceCode.getBytes();
            if (bytes.length == 0) {
                bytes = "<empty source code>".getBytes();
            }
            resultMessage.addPayload(SOURCECODE_OUTPUT_NAME, new ByteArrayInputStream(bytes));
        }
        catch (Exception e) {
            logger.error((Object)"Could not send analysis source code", (Throwable)e);
            resultMessage.setState(JobState.ERROR);
            resultMessage.setErrorMessage("Could not send analysis source code.");
        }
        return resultMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.jobsLock;
        synchronized (object) {
            loggerStatus.info((Object)("received jobs: " + this.receivedJobs.size() + ", scheduled jobs: " + this.scheduledJobs.size() + ", running jobs: " + this.runningJobs.size()));
        }
    }

    private boolean initWorkDir() {
        this.workDir = new File(workDirBase, this.id);
        if (this.workDir.exists()) {
            logger.error((Object)("Working directory " + this.workDir + " already exists, should be unique."));
            return false;
        }
        return this.workDir.mkdirs();
    }

    private class TimeoutTimerTask
    extends TimerTask {
        private TimeoutTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = AnalyserServer.this.jobsLock;
            synchronized (object) {
                ArrayList<AnalysisJob> jobsToBeRemoved = new ArrayList<AnalysisJob>();
                for (AnalysisJob job : AnalyserServer.this.receivedJobs.values()) {
                    if (System.currentTimeMillis() - (long)(RECEIVE_TIMEOUT * 1000) <= job.getReceiveTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (AnalysisJob job : jobsToBeRemoved) {
                    AnalyserServer.this.receivedJobs.remove(job.getId());
                    logger.debug((Object)("Removing old received job: " + job.getId()));
                    logger.debug((Object)("Jobs received: " + AnalyserServer.this.receivedJobs.size() + ", scheduled: " + AnalyserServer.this.scheduledJobs.size() + ", running: " + AnalyserServer.this.runningJobs.size()));
                }
                jobsToBeRemoved.clear();
                for (AnalysisJob job : AnalyserServer.this.scheduledJobs.values()) {
                    if (System.currentTimeMillis() - (long)(SCHEDULE_TIMEOUT * 1000) <= job.getScheduleTime().getTime()) break;
                    jobsToBeRemoved.add(job);
                }
                for (AnalysisJob job : jobsToBeRemoved) {
                    AnalyserServer.this.scheduledJobs.remove(job.getId());
                    logger.debug((Object)("Removing old scheduled job: " + job.getId()));
                    AnalyserServer.this.activeJobRemoved();
                    logger.debug((Object)("Jobs received: " + AnalyserServer.this.receivedJobs.size() + ", scheduled: " + AnalyserServer.this.scheduledJobs.size() + ", running: " + AnalyserServer.this.runningJobs.size()));
                }
            }
        }
    }
}

