/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.config.LoadTimeWeaverBeanDefinitionParser;
import org.springframework.context.config.MBeanExportBeanDefinitionParser;
import org.springframework.context.config.MBeanServerBeanDefinitionParser;
import org.springframework.context.config.PropertyPlaceholderBeanDefinitionParser;
import org.springframework.context.config.SpringConfiguredBeanDefinitionParser;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class ContextNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("property-placeholder", (BeanDefinitionParser)new PropertyPlaceholderBeanDefinitionParser());
        this.registerJava5DependentParser("annotation-config", "org.springframework.context.annotation.AnnotationConfigBeanDefinitionParser");
        this.registerJava5DependentParser("component-scan", "org.springframework.context.annotation.ComponentScanBeanDefinitionParser");
        this.registerBeanDefinitionParser("load-time-weaver", (BeanDefinitionParser)new LoadTimeWeaverBeanDefinitionParser());
        this.registerBeanDefinitionParser("spring-configured", new SpringConfiguredBeanDefinitionParser());
        this.registerBeanDefinitionParser("mbean-export", (BeanDefinitionParser)new MBeanExportBeanDefinitionParser());
        this.registerBeanDefinitionParser("mbean-server", (BeanDefinitionParser)new MBeanServerBeanDefinitionParser());
    }

    private void registerJava5DependentParser(final String elementName, final String parserClassName) {
        BeanDefinitionParser parser = null;
        if (JdkVersion.isAtLeastJava15()) {
            try {
                Class parserClass = ClassUtils.forName((String)parserClassName, (ClassLoader)ContextNamespaceHandler.class.getClassLoader());
                parser = (BeanDefinitionParser)parserClass.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to create Java 1.5 dependent parser: " + parserClassName, ex);
            }
        } else {
            parser = new BeanDefinitionParser(){

                public BeanDefinition parse(Element element, ParserContext parserContext) {
                    throw new IllegalStateException("Context namespace element '" + elementName + "' and its parser class [" + parserClassName + "] are only available on JDK 1.5 and higher");
                }
            };
        }
        this.registerBeanDefinitionParser(elementName, parser);
    }
}

