/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.PainterIcon;

public class JXBusyLabel
extends JLabel {
    private BusyPainter busyPainter = new BusyPainter();
    private Timer busy;
    private boolean running;

    public JXBusyLabel() {
        this.busyPainter.setBaseColor(Color.LIGHT_GRAY);
        this.busyPainter.setHighlightColor(this.getForeground());
        Dimension dim = new Dimension(26, 26);
        PainterIcon icon = new PainterIcon(dim);
        icon.setPainter(this.busyPainter);
        this.setIcon(icon);
    }

    public boolean isBusy() {
        return this.busy != null;
    }

    public void setBusy(boolean busy) {
        boolean old = this.isBusy();
        if (!old && busy) {
            this.running = true;
            this.startAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        } else if (old && !busy) {
            this.running = false;
            this.stopAnimation();
            this.firePropertyChange("busy", old, this.isBusy());
        }
    }

    private void startAnimation() {
        if (!this.running || this.getParent() == null) {
            return;
        }
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(100, new ActionListener(){
            int frame = 8;

            public void actionPerformed(ActionEvent e) {
                this.frame = (this.frame + 1) % 8;
                JXBusyLabel.this.busyPainter.setFrame(this.frame);
                JXBusyLabel.this.repaint();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        this.busy.stop();
        this.busyPainter.setFrame(-1);
        this.repaint();
        this.busy = null;
    }

    public void removeNotify() {
        this.stopAnimation();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        this.startAnimation();
    }
}

