/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.net.URI;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;

public class ConnectorXBeanConfigTest
extends TestCase {
    protected BrokerService brokerService;

    public void testConnectorConfiguredCorrectly() throws Exception {
        TransportConnector connector = (TransportConnector)this.brokerService.getTransportConnectors().get(0);
        ConnectorXBeanConfigTest.assertEquals((Object)new URI("tcp://localhost:61636"), (Object)connector.getUri());
        ConnectorXBeanConfigTest.assertTrue((connector.getTaskRunnerFactory() == this.brokerService.getTaskRunnerFactory() ? 1 : 0) != 0);
        NetworkConnector netConnector = (NetworkConnector)this.brokerService.getNetworkConnectors().get(0);
        List excludedDestinations = netConnector.getExcludedDestinations();
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQQueue("exclude.test.foo"), excludedDestinations.get(0));
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQTopic("exclude.test.bar"), excludedDestinations.get(1));
        List dynamicallyIncludedDestinations = netConnector.getDynamicallyIncludedDestinations();
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQQueue("include.test.foo"), dynamicallyIncludedDestinations.get(0));
        ConnectorXBeanConfigTest.assertEquals((Object)new ActiveMQTopic("include.test.bar"), dynamicallyIncludedDestinations.get(1));
    }

    protected void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
    }

    protected void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    protected BrokerService createBroker() throws Exception {
        String uri = "org/apache/activemq/xbean/connector-test.xml";
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

