/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.reliable;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.reliable.DropCommandStrategy;
import org.apache.activemq.transport.reliable.ReplayBuffer;
import org.apache.activemq.transport.udp.CommandDatagramSocket;
import org.apache.activemq.transport.udp.DatagramHeaderMarshaller;
import org.apache.activemq.transport.udp.UdpTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnreliableCommandDatagramSocket
extends CommandDatagramSocket {
    private static final Log LOG = LogFactory.getLog(UnreliableCommandDatagramSocket.class);
    private DropCommandStrategy dropCommandStrategy;

    public UnreliableCommandDatagramSocket(UdpTransport transport, OpenWireFormat wireFormat, int datagramSize, SocketAddress targetAddress, DatagramHeaderMarshaller headerMarshaller, DatagramSocket channel, DropCommandStrategy strategy) {
        super(transport, wireFormat, datagramSize, targetAddress, headerMarshaller, channel);
        this.dropCommandStrategy = strategy;
    }

    protected void sendWriteBuffer(int commandId, SocketAddress address, byte[] data, boolean redelivery) throws IOException {
        if (this.dropCommandStrategy.shouldDropCommand(commandId, address, redelivery)) {
            LOG.info((Object)("Dropping datagram with command: " + commandId));
            ReplayBuffer bufferCache = this.getReplayBuffer();
            if (bufferCache != null && !redelivery) {
                bufferCache.addBuffer(commandId, (Object)data);
            }
        } else {
            super.sendWriteBuffer(commandId, address, data, redelivery);
        }
    }
}

