/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.apache.activemq.kaha.Loader;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.kaha.impl.KahaStore;

public class LoadTest
extends TestCase {
    static final int COUNT = 10000;
    static final int NUM_LOADERS = 5;
    protected String name = "load.db";
    protected KahaStore store;

    public void testLoad() throws Exception {
        CountDownLatch start = new CountDownLatch(5);
        CountDownLatch stop = new CountDownLatch(5);
        for (int i = 0; i < 5; ++i) {
            Loader loader = new Loader("loader:" + i, (Store)this.store, 10000, start, stop);
            loader.start();
        }
        stop.await();
    }

    protected KahaStore getStore() throws IOException {
        return (KahaStore)StoreFactory.open((String)this.name, (String)"rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/load.db";
        StoreFactory.delete((String)this.name);
        this.store = this.getStore();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.store.clear();
        this.store.close();
        LoadTest.assertTrue((boolean)StoreFactory.delete((String)this.name));
    }
}

