/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DestinationCursorConfigTest
extends TestSupport {
    protected BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)new ClassPathResource("org/apache/activemq/broker/policy/cursor.xml"));
        factory.afterPropertiesSet();
        BrokerService answer = factory.getBroker();
        return answer;
    }

    public void testQueueConfiguration() throws Exception {
        this.topic = false;
        ActiveMQDestination destination = (ActiveMQDestination)this.createDestination("org.apache.foo");
        PolicyEntry entry = this.broker.getDestinationPolicy().getEntryFor(destination);
        PendingQueueMessageStoragePolicy policy = entry.getPendingQueuePolicy();
        DestinationCursorConfigTest.assertNotNull((Object)policy);
        DestinationCursorConfigTest.assertTrue((String)("Policy is: " + policy), (boolean)(policy instanceof VMPendingQueueMessageStoragePolicy));
    }

    public void testTopicConfiguration() throws Exception {
        this.topic = true;
        ActiveMQDestination destination = (ActiveMQDestination)this.createDestination("org.apache.foo");
        PolicyEntry entry = this.broker.getDestinationPolicy().getEntryFor(destination);
        PendingSubscriberMessageStoragePolicy policy = entry.getPendingSubscriberPolicy();
        DestinationCursorConfigTest.assertNotNull((Object)policy);
        DestinationCursorConfigTest.assertFalse((boolean)entry.isProducerFlowControl());
        DestinationCursorConfigTest.assertTrue((entry.getMemoryLimit() == 0x100000L ? 1 : 0) != 0);
        DestinationCursorConfigTest.assertTrue((String)("subscriberPolicy is: " + policy), (boolean)(policy instanceof VMPendingSubscriberMessageStoragePolicy));
    }
}

