/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTest;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;

public abstract class TransportBrokerTestSupport
extends BrokerTest {
    protected TransportConnector connector;
    private ArrayList<StubConnection> connections = new ArrayList();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService service = super.createBroker();
        this.connector = service.addConnector(this.getBindLocation());
        return service;
    }

    protected abstract String getBindLocation();

    protected void tearDown() throws Exception {
        Iterator<StubConnection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            StubConnection connection = iter.next();
            connection.stop();
            iter.remove();
        }
        if (this.connector != null) {
            this.connector.stop();
        }
        super.tearDown();
    }

    protected URI getBindURI() throws URISyntaxException {
        return new URI(this.getBindLocation());
    }

    protected StubConnection createConnection() throws Exception {
        URI bindURI = this.getBindURI();
        URI actualURI = this.connector.getServer().getConnectURI();
        URI connectURI = new URI(actualURI.getScheme(), actualURI.getUserInfo(), bindURI.getHost(), actualURI.getPort(), actualURI.getPath(), actualURI.getQuery(), actualURI.getFragment());
        Transport transport = TransportFactory.connect(connectURI);
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }
}

