/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQQueue;

public class JMSExclusiveConsumerTest
extends JmsTestSupport {
    public int deliveryMode;

    public static Test suite() {
        return JMSExclusiveConsumerTest.suite(JMSExclusiveConsumerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JMSExclusiveConsumerTest.suite());
    }

    public void initCombosForTestRoundRobinDispatchOnNonExclusive() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testRoundRobinDispatchOnNonExclusive() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        MessageConsumer consumer1 = session.createConsumer(destination);
        MessageConsumer consumer2 = session.createConsumer(destination);
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        Message m = consumer2.receive(1000L);
        JMSExclusiveConsumerTest.assertNotNull((Object)m);
        m = consumer1.receive(1000L);
        JMSExclusiveConsumerTest.assertNotNull((Object)m);
        JMSExclusiveConsumerTest.assertNull((Object)consumer1.receiveNoWait());
        JMSExclusiveConsumerTest.assertNull((Object)consumer2.receiveNoWait());
    }

    public void initCombosForTestDispatchExclusive() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
    }

    public void testDispatchExclusive() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST?consumer.exclusive=true");
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(this.deliveryMode);
        MessageConsumer consumer1 = session.createConsumer(destination);
        MessageConsumer consumer2 = session.createConsumer(destination);
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        producer.send(session.createTextMessage("3nd"));
        Message m = consumer2.receive(1000L);
        if (m != null) {
            for (int i = 0; i < 2; ++i) {
                m = consumer2.receive(1000L);
                JMSExclusiveConsumerTest.assertNotNull((Object)m);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                m = consumer1.receive(1000L);
                JMSExclusiveConsumerTest.assertNotNull((Object)m);
            }
        }
        JMSExclusiveConsumerTest.assertNull((Object)consumer1.receiveNoWait());
        JMSExclusiveConsumerTest.assertNull((Object)consumer2.receiveNoWait());
    }

    public void testMixExclusiveWithNonExclusive() throws Exception {
        ActiveMQQueue exclusiveQueue = new ActiveMQQueue("TEST.FOO?consumer.exclusive=true");
        ActiveMQQueue nonExclusiveQueue = new ActiveMQQueue("TEST.FOO?consumer.exclusive=false");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        MessageConsumer nonExCon = session.createConsumer(nonExclusiveQueue);
        MessageConsumer exCon = session.createConsumer(exclusiveQueue);
        MessageProducer prod = session.createProducer(exclusiveQueue);
        prod.send(session.createMessage());
        prod.send(session.createMessage());
        prod.send(session.createMessage());
        for (int i = 0; i < 3; ++i) {
            Message m = exCon.receive(1000L);
            JMSExclusiveConsumerTest.assertNotNull((Object)m);
            m = nonExCon.receive(1000L);
            JMSExclusiveConsumerTest.assertNull((Object)m);
        }
    }
}

