/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.jfree.chart.BioChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ClusteringTreeChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.event.SelectionChangeEvent;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.plot.HCTreeNodeInfo;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HeatMap;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HCDemo1
extends ApplicationFrame
implements PlotChangeListener {
    public HCDemo1(String title, String filename) {
        super(title);
        HCDataset dataset = HCDemo1.createDataset(filename);
        JFreeChart chart = HCDemo1.createChart(dataset);
        int width = dataset.getHeatMap().getColumnsCount() * 40;
        int height = dataset.getHeatMap().getRowCount() * 40;
        while (width * height > 10000000) {
            width /= 2;
            height /= 2;
        }
        ChartPanel chartPanel = new ChartPanel(chart, width, height, width / 2, height / 2, width * 2, height * 2, true, true, true, true, false, true);
        JScrollPane scroll = new JScrollPane(chartPanel);
        HCPlot plot = (HCPlot)chart.getPlot();
        plot.addChangeListener(this);
        chartPanel.addChartMouseListener((HCPlot)chart.getPlot());
        JPopupMenu popup = chartPanel.getPopupMenu();
        JMenuItem xItem = new JMenuItem("Expand all");
        popup.add(xItem);
        chartPanel.setPopupMenu(popup);
        this.setContentPane(scroll);
        HCDemo1.printHCDataset(dataset);
    }

    public void plotChanged(PlotChangeEvent event) {
        if (event instanceof SelectionChangeEvent) {
            HCPlot plot = (HCPlot)event.getPlot();
            System.out.println(plot.getSelection());
        } else if (event instanceof ClusteringTreeChangeEvent) {
            HCTreeNodeInfo info = ((ClusteringTreeChangeEvent)event).getTreeNodeInfo();
            System.out.println("selection changed at subtree " + info);
        }
    }

    private static HCDataset createDataset(String filename) {
        HCDataset dataset;
        HeatMap heatMap;
        HCTreeNode topTree;
        HCTreeNode leftTree;
        BufferedReader input;
        try {
            input = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        }
        catch (Exception e) {
            System.out.println("1: " + e);
            e.printStackTrace();
            return null;
        }
        try {
            leftTree = HCDemo1.readTree(input, 0);
            topTree = HCDemo1.readTree(input, 0);
        }
        catch (Exception e) {
            System.out.println("2: " + e);
            e.printStackTrace();
            leftTree = null;
            topTree = null;
        }
        try {
            heatMap = HCDemo1.readHeatMap(input);
        }
        catch (Exception e) {
            System.out.println("3: " + e);
            e.printStackTrace();
            heatMap = null;
        }
        try {
            dataset = new HCDataset(heatMap, leftTree, topTree);
        }
        catch (Exception e) {
            System.out.println("4: " + e);
            e.printStackTrace();
            dataset = null;
        }
        return dataset;
    }

    private static HeatMap readHeatMap(BufferedReader input) throws Exception {
        int y;
        int x;
        String line = input.readLine();
        int width = Integer.parseInt(line);
        line = input.readLine();
        int height = Integer.parseInt(line);
        HeatMap heatMap = new HeatMap("X", height, width);
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                line = input.readLine();
                heatMap.update(y, x, Double.parseDouble(line));
            }
        }
        for (x = 0; x < width; ++x) {
            heatMap.setColumnName(x, "t" + x);
        }
        for (y = 0; y < height; ++y) {
            int i = y;
            String s = "";
            for (int j = 0; j < 3; ++j) {
                s = (char)(65 + i % 5) + s;
                i /= 5;
            }
            heatMap.setRowName(y, "G_" + s);
        }
        return heatMap;
    }

    private static HCTreeNode readTree(BufferedReader input, int index) throws Exception {
        String line = input.readLine();
        if (line.equals("x")) {
            return null;
        }
        if (line.equals("l")) {
            return new HCTreeNode(0.0, index);
        }
        HCTreeNode node = new HCTreeNode(Double.parseDouble(line));
        HCTreeNode leftChild = HCDemo1.readTree(input, index);
        node.setLeftChild(leftChild);
        HCTreeNode rightChild = HCDemo1.readTree(input, node.getDataRange().getRightBound() + 1);
        node.setRightChild(rightChild);
        return node;
    }

    private static void printTree(HCTreeNode node, int level) {
        System.out.print("---+");
        if (node.getLeftChild() == null && node.getRightChild() == null) {
            System.out.println(node.getDataRange());
        }
        if (node.getLeftChild() != null) {
            HCDemo1.printTree(node.getLeftChild(), level + 1);
        }
        if (node.getRightChild() != null) {
            for (int i = 0; i < level; ++i) {
                System.out.print("   |");
            }
            System.out.print("   \\");
            HCDemo1.printTree(node.getRightChild(), level + 1);
        }
    }

    private static void printHCDataset(HCDataset dataset) {
    }

    private static JFreeChart createChart(HCDataset dataset) {
        JFreeChart chart = BioChartFactory.createHCChart("Hierarchical Clustering Demo", dataset, true, false);
        return chart;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Please give datafile name as a commandline argument.");
            System.exit(1);
        } else if (args.length > 1) {
            System.out.println("No more than one command line argument is allowed.");
            System.exit(1);
        }
        HCDemo1 demo = new HCDemo1("HC Chart Demo", args[0]);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        demo.setVisible(true);
    }
}

