/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.test.JmsTopicSendReceiveTest;

public class JmsQueueWildcardSendReceiveTest
extends JmsTopicSendReceiveTest {
    private String destination1String = "TEST.ONE.ONE";
    private String destination2String = "TEST.ONE.ONE.ONE";
    private String destination3String = "TEST.ONE.TWO";
    private String destination4String = "TEST.TWO.ONE";

    protected void setUp() throws Exception {
        this.topic = false;
        this.deliveryMode = 1;
        super.setUp();
    }

    protected String getConsumerSubject() {
        return "FOO.>";
    }

    protected String getProducerSubject() {
        return "FOO.BAR.HUMBUG";
    }

    public void testReceiveWildcardQueueEndAsterisk() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)((Object)session.createQueue(this.destination1String));
        ActiveMQDestination destination3 = (ActiveMQDestination)((Object)session.createQueue(this.destination3String));
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        this.sendMessage(session, destination1, this.destination1String);
        this.sendMessage(session, destination3, this.destination3String);
        ActiveMQDestination destination6 = (ActiveMQDestination)((Object)session.createQueue("TEST.ONE.*"));
        consumer = session.createConsumer(destination6);
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination3String)) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination3String)) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsQueueWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testReceiveWildcardQueueEndGreaterThan() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)((Object)session.createQueue(this.destination1String));
        ActiveMQDestination destination2 = (ActiveMQDestination)((Object)session.createQueue(this.destination2String));
        ActiveMQDestination destination3 = (ActiveMQDestination)((Object)session.createQueue(this.destination3String));
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        this.sendMessage(session, destination1, this.destination1String);
        this.sendMessage(session, destination2, this.destination2String);
        this.sendMessage(session, destination3, this.destination3String);
        ActiveMQDestination destination7 = (ActiveMQDestination)((Object)session.createQueue("TEST.ONE.>"));
        consumer = session.createConsumer(destination7);
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!(text.equals(this.destination1String) || text.equals(this.destination2String) || text.equals(this.destination3String))) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        if (!(text.equals(this.destination1String) || text.equals(this.destination2String) || text.equals(this.destination3String))) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        if (!(text.equals(this.destination1String) || text.equals(this.destination2String) || text.equals(this.destination3String))) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsQueueWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testReceiveWildcardQueueMidAsterisk() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)((Object)session.createQueue(this.destination1String));
        ActiveMQDestination destination4 = (ActiveMQDestination)((Object)session.createQueue(this.destination4String));
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        this.sendMessage(session, destination1, this.destination1String);
        this.sendMessage(session, destination4, this.destination4String);
        ActiveMQDestination destination8 = (ActiveMQDestination)((Object)session.createQueue("TEST.*.ONE"));
        consumer = session.createConsumer(destination8);
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination4String)) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsQueueWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination4String)) {
            JmsQueueWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsQueueWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    private void sendMessage(Session session, Destination destination, String text) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.send(session.createTextMessage(text));
        producer.close();
    }
}

