/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util.config;

import fi.csc.microarray.util.XmlUtil;
import fi.csc.microarray.util.config.Configuration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static final String VERSION_ATTRIBUTE = "content-version";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFromFile(Configuration configuration, File file, int requiredVersion) throws IOException, SAXException, ParserConfigurationException, OldConfigurationFormatException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            ConfigurationLoader.addFromStream(configuration, in, requiredVersion);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    public static void addFromStream(Configuration configuration, InputStream stream, int requiredVersion) throws SAXException, IOException, ParserConfigurationException, OldConfigurationFormatException {
        Document document = XmlUtil.getInstance().parseReader(new InputStreamReader(stream));
        ConfigurationLoader.addFromXml(configuration, document, requiredVersion);
    }

    public static void addFromXml(Configuration configuration, Document xml, int requiredVersion) throws OldConfigurationFormatException {
        if (requiredVersion > 0) {
            int version;
            String contentVersion = "";
            if (xml.getDocumentElement().hasAttribute(VERSION_ATTRIBUTE)) {
                contentVersion = xml.getDocumentElement().getAttribute(VERSION_ATTRIBUTE);
            }
            if (contentVersion.equals("")) {
                throw new OldConfigurationFormatException("version not specified");
            }
            try {
                version = Integer.parseInt(contentVersion);
            }
            catch (NumberFormatException e) {
                version = -1;
            }
            if (version < requiredVersion) {
                throw new OldConfigurationFormatException("too old version (" + version + " when required is " + requiredVersion + ")");
            }
        }
        ConfigurationLoader.addFromNode(configuration, xml.getDocumentElement());
    }

    private static void addFromNode(Configuration configuration, Element element) {
        NodeList entries = element.getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            String name = ((Element)entries.item(i)).getAttribute("entryKey");
            NodeList values = ((Element)entries.item(i)).getElementsByTagName("value");
            for (int v = 0; v < values.getLength(); ++v) {
                configuration.addValue(name, values.item(v).getTextContent());
            }
        }
        NodeList modules = element.getElementsByTagName("configuration-module");
        for (int i = 0; i < modules.getLength(); ++i) {
            String name = ((Element)modules.item(i)).getAttribute("moduleId");
            if (!configuration.hasSubModule(name)) {
                configuration.createSubModule(name);
            }
            ConfigurationLoader.addFromNode(configuration.getModule(name), (Element)modules.item(i));
        }
    }

    public static class OldConfigurationFormatException
    extends Exception {
        public OldConfigurationFormatException(String string) {
            super(string);
        }
    }
}

