/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import fi.csc.microarray.client.visualisation.methods.threed.Line;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModel {
    private static final Logger logger = Logger.getLogger(DataModel.class);
    private Color lineColor = Color.DARK_GRAY;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private ColorModel colorModel = new ColorModel();
    private Drawable[] points;
    private static final int LINE_COUNT = 4;
    private float[] cScale;

    public DataModel() {
        this.numberFormat.setMaximumFractionDigits(2);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setData(Iterable<String> identifiers, Iterable<Float> xValues, Iterable<Float> yValues, Iterable<Float> zValues, Iterable<Float> cValues) {
        ArrayList<Drawable> points = new ArrayList<Drawable>();
        Iterator<String> identIter = identifiers.iterator();
        Iterator<Float> xIter = xValues.iterator();
        Iterator<Float> yIter = yValues.iterator();
        Iterator<Float> zIter = zValues.iterator();
        Iterator<Float> cIter = cValues.iterator();
        long time = 0L;
        logger.debug((System.currentTimeMillis() - time) / 1000L);
        time = System.currentTimeMillis();
        float[] minMaxX = this.findMinMaxValues(xIter);
        float[] minMaxY = this.findMinMaxValues(yIter);
        float[] minMaxZ = this.findMinMaxValues(zIter);
        float[] minMaxC = this.findMinMaxValues(cIter);
        logger.debug((System.currentTimeMillis() - time) / 1000L);
        time = System.currentTimeMillis();
        float[] xScale = this.generateScaleValues(minMaxX[0], minMaxX[1]);
        float[] yScale = this.generateScaleValues(minMaxY[0], minMaxY[1]);
        float[] zScale = this.generateScaleValues(minMaxZ[0], minMaxZ[1]);
        this.cScale = this.generateScaleValues(minMaxC[0], minMaxC[1]);
        points.addAll(this.generateScaleLines(xScale, yScale, zScale));
        xIter = xValues.iterator();
        yIter = yValues.iterator();
        zIter = zValues.iterator();
        cIter = cValues.iterator();
        logger.debug((System.currentTimeMillis() - time) / 1000L);
        time = System.currentTimeMillis();
        xIter = xValues.iterator();
        yIter = yValues.iterator();
        zIter = zValues.iterator();
        cIter = cValues.iterator();
        int i = 0;
        while (identIter.hasNext() && xIter.hasNext() && yIter.hasNext() && zIter.hasNext() && cIter.hasNext()) {
            String identifier = identIter.next();
            float x = xIter.next().floatValue();
            float y = yIter.next().floatValue();
            float z = zIter.next().floatValue();
            float c = cIter.next().floatValue();
            float[] scaled = this.convertToScaled(xScale, yScale, zScale, this.cScale, new float[]{x, y, z, c});
            Color color = this.colorModel.getColorFor(scaled[3]);
            points.add(new DataPoint((double)scaled[0], (double)scaled[1], (double)scaled[2], color, 0.01, identifier, i));
            ++i;
        }
        logger.debug((System.currentTimeMillis() - time) / 1000L);
        time = System.currentTimeMillis();
        this.points = new Drawable[points.size()];
        for (i = 0; i < points.size(); ++i) {
            this.points[i] = (Drawable)points.get(i);
        }
        logger.debug((System.currentTimeMillis() - time) / 1000L);
        time = System.currentTimeMillis();
    }

    private float[] findMinMaxValues(Iterator<Float> iter) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        while (iter.hasNext()) {
            float x = iter.next().floatValue();
            if (x > max) {
                max = x;
            }
            if (!(x < min)) continue;
            min = x;
        }
        return new float[]{min, max};
    }

    public Drawable[] getDataArray() {
        return this.points;
    }

    private float[] convertToScaled(float[] xScale, float[] yScale, float[] zScale, float[] cScale, float[] original) {
        return new float[]{(original[0] - xScale[0]) / (xScale[3] - xScale[0]), (original[1] - yScale[0]) / (yScale[3] - yScale[0]), (original[2] - zScale[0]) / (zScale[3] - zScale[0]), (original[3] - cScale[0]) / (cScale[3] - cScale[0])};
    }

    private String[] coordToStringTable(float x, float y, float z) {
        return new String[]{"(", "" + x, ", ", "" + y, ", ", "" + z, ")"};
    }

    private List<Drawable> generateScaleLines(float[] xValues, float[] yValues, float[] zValues) {
        Color[] tripletColors = new Color[]{Color.WHITE, Color.RED, Color.WHITE, Color.GREEN, Color.WHITE, Color.BLUE, Color.WHITE};
        ArrayList<Drawable> lines = new ArrayList<Drawable>();
        lines.add(new Line(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, Color.RED, this.coordToStringTable(xValues[3], yValues[0], zValues[0]), tripletColors));
        lines.add(new Line(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, Color.GREEN, this.coordToStringTable(xValues[0], yValues[3], zValues[0]), tripletColors));
        lines.add(new Line(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Color.BLUE, this.coordToStringTable(xValues[0], yValues[0], zValues[3]), tripletColors));
        lines.add(new Line(1.0, 0.0, 0.0, 0.99, 0.005, -0.01, Color.RED, ""));
        lines.add(new Line(1.0, 0.0, 0.0, 0.99, -0.01, 0.005, Color.RED, ""));
        lines.add(new Line(0.0, 1.0, 0.0, 0.005, 0.99, -0.01, Color.GREEN, ""));
        lines.add(new Line(0.0, 1.0, 0.0, -0.01, 0.99, 0.005, Color.GREEN, ""));
        lines.add(new Line(0.0, 0.0, 1.0, -0.01, 0.005, 0.99, Color.BLUE, ""));
        lines.add(new Line(0.0, 0.0, 1.0, 0.005, -0.01, 0.99, Color.BLUE, ""));
        Color[] xTextColor = new Color[]{Color.WHITE};
        Color[] yTextColor = new Color[]{Color.WHITE};
        Color[] zTextColor = new Color[]{Color.WHITE};
        for (int i = 1; i < 4; ++i) {
            String[] zText;
            String[] yText;
            String[] xText;
            float pos = (float)i / 3.0f;
            if (i != 3) {
                xText = new String[]{this.numberFormat.format(xValues[i])};
                yText = new String[]{this.numberFormat.format(yValues[i])};
                zText = new String[]{this.numberFormat.format(zValues[i])};
                xTextColor = new Color[]{Color.RED};
                yTextColor = new Color[]{Color.GREEN};
                zTextColor = new Color[]{Color.BLUE};
            } else {
                xText = null;
                yText = null;
                zText = null;
                xTextColor = tripletColors;
                yTextColor = tripletColors;
                zTextColor = tripletColors;
            }
            lines.add(new Line(pos, 0.0, 0.0, pos, 1.0, 0.0, this.lineColor, xText, xTextColor));
            if (xText == null) {
                xText = this.coordToStringTable(xValues[i], yValues[0], zValues[i]);
            }
            lines.add(new Line(pos, 0.0, 0.0, pos, 0.0, 1.0, this.lineColor, xText, xTextColor));
            lines.add(new Line(0.0, pos, 0.0, 0.0, pos, 1.0, this.lineColor, yText, yTextColor));
            if (yText == null) {
                yText = this.coordToStringTable(xValues[i], yValues[i], zValues[0]);
            }
            lines.add(new Line(0.0, pos, 0.0, 1.0, pos, 0.0, this.lineColor, yText, yTextColor));
            lines.add(new Line(0.0, 0.0, pos, 1.0, 0.0, pos, this.lineColor, zText, zTextColor));
            if (zText == null) {
                zText = this.coordToStringTable(xValues[0], yValues[i], zValues[i]);
            }
            lines.add(new Line(0.0, 0.0, pos, 0.0, 1.0, pos, this.lineColor, zText, zTextColor));
        }
        return lines;
    }

    private float[] generateScaleValues(float min, float max) {
        float[] scaleMinMax = this.getLineDistance(min, max);
        float[] values = new float[4];
        for (int i = 0; i < 4; ++i) {
            values[i] = scaleMinMax[0] + (scaleMinMax[1] - scaleMinMax[0]) / 3.0f * (float)i;
        }
        return values;
    }

    private float[] getLineDistance(float minValue, float maxValue) {
        float preferredScale = Math.abs(maxValue - minValue) / 3.0f;
        float decimalFactor = this.calculateDecimalFactor(preferredScale);
        float scaleMax = (float)((int)((double)(maxValue / decimalFactor) + 1.0)) * decimalFactor;
        float scaleMin = (float)((int)(minValue / decimalFactor)) * decimalFactor;
        if (minValue < 0.0f) {
            scaleMin -= 1.0f;
        }
        return new float[]{scaleMin, scaleMax};
    }

    private float calculateDecimalFactor(float preferredScale) {
        float decimalFactor = 1.0f;
        if (preferredScale >= 10.0f) {
            while (preferredScale >= decimalFactor * 10.0f) {
                decimalFactor *= 10.0f;
            }
        } else {
            while (preferredScale < decimalFactor / 10.0f) {
                decimalFactor /= 10.0f;
            }
        }
        return decimalFactor;
    }

    public float[] getColorScaleValues() {
        return this.cScale;
    }

    public class ColorModel {
        final float BLUE_HUE = Color.RGBtoHSB(0, 0, 255, new float[3])[0];

        public Color getColorFor(float value) {
            value = this.BLUE_HUE - this.BLUE_HUE * value;
            return new Color(Color.HSBtoRGB(value, 1.0f, 1.0f));
        }
    }
}

