/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.resequencer.ExpressionResultComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchangeComparator
implements ExpressionResultComparator<Exchange> {
    private Expression<Exchange> expression;

    public Expression<Exchange> getExpression() {
        return this.expression;
    }

    public void setExpression(Expression<Exchange> expression) {
        this.expression = expression;
    }

    @Override
    public void setExpressions(List<Expression> expressions) {
        if (expressions.isEmpty()) {
            throw new IllegalArgumentException("Expression required to resolve sequence number");
        }
        if (expressions.size() > 1) {
            throw new IllegalArgumentException("More than one expression currently not supported");
        }
        this.expression = expressions.get(0);
    }

    @Override
    public boolean predecessor(Exchange o1, Exchange o2) {
        long n2;
        long n1 = this.getSequenceNumber(o1);
        return n1 == (n2 = this.getSequenceNumber(o2)) - 1L;
    }

    @Override
    public boolean successor(Exchange o1, Exchange o2) {
        long n1 = this.getSequenceNumber(o1);
        long n2 = this.getSequenceNumber(o2);
        return n2 == n1 - 1L;
    }

    @Override
    public int compare(Exchange o1, Exchange o2) {
        Long n1 = this.getSequenceNumber(o1);
        Long n2 = this.getSequenceNumber(o2);
        return n1.compareTo(n2);
    }

    private long getSequenceNumber(Exchange exchange) {
        return (Long)this.expression.evaluate(exchange);
    }
}

