/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.util.ExpressionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Delayer
extends DelayProcessorSupport {
    private Expression<Exchange> timeExpression;
    private long delay;

    public Delayer(Processor processor, Expression<Exchange> timeExpression, long delay) {
        super(processor);
        this.timeExpression = timeExpression;
        this.delay = delay;
    }

    @Override
    public String toString() {
        return "Delayer[on: " + this.timeExpression + " delay: " + this.delay + " to: " + this.getProcessor() + "]";
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Override
    protected void delay(Exchange exchange) throws Exception {
        Long longValue;
        long time = 0L;
        if (this.timeExpression != null && (longValue = ExpressionHelper.evaluateAsType(this.timeExpression, exchange, Long.class)) != null) {
            time = longValue;
        }
        if (time <= 0L) {
            time = this.defaultProcessTime(exchange);
        }
        this.waitUntil(time += this.delay, exchange);
    }

    protected long defaultProcessTime(Exchange exchange) {
        return this.currentSystemTime();
    }
}

