/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.Throttler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="throttler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrottlerType
extends ProcessorType<ProcessorType> {
    @XmlAttribute
    private Long maximumRequestsPerPeriod;
    @XmlAttribute
    private long timePeriodMillis = 1000L;
    @XmlElementRef
    private List<ProcessorType<?>> outputs = new ArrayList();

    public ThrottlerType() {
    }

    public ThrottlerType(long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public String toString() {
        return "Throttler[" + this.getMaximumRequestsPerPeriod() + " request per " + this.getTimePeriodMillis() + " millis -> " + this.getOutputs() + "]";
    }

    @Override
    public String getLabel() {
        return "" + this.getMaximumRequestsPerPeriod() + " per " + this.getTimePeriodMillis() + " (ms)";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = routeContext.createProcessor(this);
        return new Throttler(childProcessor, this.maximumRequestsPerPeriod, this.timePeriodMillis);
    }

    public ThrottlerType timePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
        return this;
    }

    public Long getMaximumRequestsPerPeriod() {
        return this.maximumRequestsPerPeriod;
    }

    public void setMaximumRequestsPerPeriod(Long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public long getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorType<?>> outputs) {
        this.outputs = outputs;
    }
}

