/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.AggregatorType;
import org.apache.camel.model.BeanRef;
import org.apache.camel.model.Block;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.DelayerType;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.model.FilterType;
import org.apache.camel.model.IdempotentConsumerType;
import org.apache.camel.model.InterceptType;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.model.LoadBalanceType;
import org.apache.camel.model.MarshalType;
import org.apache.camel.model.MulticastType;
import org.apache.camel.model.NodeFactory;
import org.apache.camel.model.PolicyRef;
import org.apache.camel.model.ProceedType;
import org.apache.camel.model.ProcessorRef;
import org.apache.camel.model.RecipientListType;
import org.apache.camel.model.ResequencerType;
import org.apache.camel.model.RoutingSlipType;
import org.apache.camel.model.SplitterType;
import org.apache.camel.model.ThreadType;
import org.apache.camel.model.ThrottlerType;
import org.apache.camel.model.ThrowFaultType;
import org.apache.camel.model.ToType;
import org.apache.camel.model.TryType;
import org.apache.camel.model.UnmarshalType;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.model.language.ExpressionType;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.aggregate.AggregationCollection;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.idempotent.MessageIdRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Policy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessorType<Type extends ProcessorType>
implements Block {
    public static final String DEFAULT_TRACE_CATEGORY = "org.apache.camel.TRACE";
    private ErrorHandlerBuilder errorHandlerBuilder;
    private Boolean inheritErrorHandlerFlag = Boolean.TRUE;
    private DelegateProcessor lastInterceptor;
    private NodeFactory nodeFactory;
    private LinkedList<Block> blocks = new LinkedList();
    private ProcessorType<? extends ProcessorType> parent;

    public abstract List<ProcessorType<?>> getOutputs();

    public Processor createProcessor(RouteContext routeContext) throws Exception {
        throw new UnsupportedOperationException("Not implemented yet for class: " + this.getClass().getName());
    }

    public Processor createOutputsProcessor(RouteContext routeContext) throws Exception {
        List<ProcessorType<?>> outputs = this.getOutputs();
        return this.createOutputsProcessor(routeContext, outputs);
    }

    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        Processor processor = this.makeProcessor(routeContext);
        routeContext.addEventDrivenProcessor(processor);
    }

    public Processor wrapProcessor(RouteContext routeContext, Processor processor) throws Exception {
        processor = this.wrapProcessorInInterceptors(routeContext, processor);
        return this.wrapInErrorHandler(processor);
    }

    public Type to(String uri) {
        this.addOutput(new ToType(uri));
        return (Type)this;
    }

    public Type to(Endpoint endpoint) {
        this.addOutput(new ToType(endpoint));
        return (Type)this;
    }

    public Type to(String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToType(uri));
        }
        return (Type)this;
    }

    public Type to(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToType(endpoint));
        }
        return (Type)this;
    }

    public Type to(Collection<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToType(endpoint));
        }
        return (Type)this;
    }

    public MulticastType multicast() {
        MulticastType answer = new MulticastType();
        this.addOutput(answer);
        return answer;
    }

    public MulticastType multicast(AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        MulticastType answer = new MulticastType();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(parallelProcessing);
        return answer;
    }

    public MulticastType multicast(AggregationStrategy aggregationStrategy) {
        MulticastType answer = new MulticastType();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public Type pipeline(String ... uris) {
        return this.to(uris);
    }

    public Type pipeline(Endpoint ... endpoints) {
        return this.to(endpoints);
    }

    public Type pipeline(Collection<Endpoint> endpoints) {
        return this.to(endpoints);
    }

    public ProcessorType<? extends ProcessorType> end() {
        if (this.blocks.isEmpty()) {
            if (this.parent == null) {
                throw new IllegalArgumentException("Root node with no active block");
            }
            return this.parent;
        }
        this.popBlock();
        return this;
    }

    public ThreadType thread(int coreSize) {
        ThreadType answer = new ThreadType(coreSize);
        this.addOutput(answer);
        return answer;
    }

    public ProcessorType<Type> thread(ThreadPoolExecutor executor) {
        ThreadType answer = new ThreadType(executor);
        this.addOutput(answer);
        return this;
    }

    public IdempotentConsumerType idempotentConsumer(Expression messageIdExpression, MessageIdRepository messageIdRepository) {
        IdempotentConsumerType answer = new IdempotentConsumerType(messageIdExpression, messageIdRepository);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<IdempotentConsumerType> idempotentConsumer(MessageIdRepository messageIdRepository) {
        IdempotentConsumerType answer = new IdempotentConsumerType();
        answer.setMessageIdRepository(messageIdRepository);
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ExpressionClause<FilterType> filter() {
        FilterType filter = new FilterType();
        this.addOutput(filter);
        return ExpressionClause.createAndSetExpression(filter);
    }

    public FilterType filter(Predicate predicate) {
        FilterType filter = new FilterType(predicate);
        this.addOutput(filter);
        return filter;
    }

    public FilterType filter(ExpressionType expression) {
        FilterType filter = this.getNodeFactory().createFilter();
        filter.setExpression(expression);
        this.addOutput(filter);
        return filter;
    }

    public FilterType filter(String language, String expression) {
        return this.filter(new LanguageExpression(language, expression));
    }

    public LoadBalanceType loadBalance() {
        LoadBalanceType answer = new LoadBalanceType();
        this.addOutput(answer);
        return answer;
    }

    public ChoiceType choice() {
        ChoiceType answer = new ChoiceType();
        this.addOutput(answer);
        return answer;
    }

    public TryType tryBlock() {
        TryType answer = new TryType();
        this.addOutput(answer);
        return answer;
    }

    public Type recipientList(Expression receipients) {
        RecipientListType answer = new RecipientListType(receipients);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorType<Type>> recipientList() {
        RecipientListType answer = new RecipientListType();
        this.addOutput(answer);
        ExpressionClause<ProcessorType<Type>> clause = new ExpressionClause<ProcessorType<Type>>(this);
        answer.setExpression(clause);
        return clause;
    }

    public Type routingSlip(String header, String uriDelimiter) {
        RoutingSlipType answer = new RoutingSlipType(header, uriDelimiter);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type routingSlip(String header) {
        RoutingSlipType answer = new RoutingSlipType(header);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type routingSlip() {
        RoutingSlipType answer = new RoutingSlipType();
        this.addOutput(answer);
        return (Type)this;
    }

    public SplitterType splitter(Expression receipients) {
        SplitterType answer = new SplitterType(receipients);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<SplitterType> splitter() {
        SplitterType answer = new SplitterType();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SplitterType splitter(Expression partsExpression, AggregationStrategy aggregationStrategy) {
        SplitterType answer = new SplitterType(partsExpression);
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public ExpressionClause<SplitterType> splitter(AggregationStrategy aggregationStrategy) {
        SplitterType answer = new SplitterType();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SplitterType splitter(Expression receipients, boolean parallelProcessing) {
        SplitterType answer = new SplitterType(receipients);
        this.addOutput(answer);
        answer.setParallelProcessing(parallelProcessing);
        return answer;
    }

    public ExpressionClause<SplitterType> splitter(boolean parallelProcessing) {
        SplitterType answer = new SplitterType();
        this.addOutput(answer);
        answer.setParallelProcessing(parallelProcessing);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public SplitterType splitter(Expression partsExpression, AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        SplitterType answer = new SplitterType(partsExpression);
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(parallelProcessing);
        return answer;
    }

    public ExpressionClause<SplitterType> splitter(AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        SplitterType answer = new SplitterType();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(parallelProcessing);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ExpressionClause<ResequencerType> resequencer() {
        ResequencerType answer = new ResequencerType();
        this.addOutput(answer);
        ExpressionClause<ResequencerType> clause = new ExpressionClause<ResequencerType>(answer);
        answer.expression(clause);
        return clause;
    }

    public ResequencerType resequencer(Expression<Exchange> expression) {
        return this.resequencer(Collections.singletonList(expression));
    }

    public ResequencerType resequencer(List<Expression> expressions) {
        ResequencerType answer = new ResequencerType(expressions);
        this.addOutput(answer);
        return answer;
    }

    public ResequencerType resequencer(Expression ... expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            list.add(expression);
        }
        return this.resequencer(list);
    }

    public ExpressionClause<AggregatorType> aggregator() {
        AggregatorType answer = new AggregatorType();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ExpressionClause<AggregatorType> aggregator(AggregationStrategy aggregationStrategy) {
        AggregatorType answer = new AggregatorType();
        answer.setAggregationStrategy(aggregationStrategy);
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public ExpressionClause<AggregatorType> aggregator(AggregationCollection aggregationCollection) {
        AggregatorType answer = new AggregatorType();
        answer.setAggregationCollection(aggregationCollection);
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public AggregatorType aggregator(Expression correlationExpression) {
        AggregatorType answer = new AggregatorType(correlationExpression);
        this.addOutput(answer);
        return answer;
    }

    public AggregatorType aggregator(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        AggregatorType answer = new AggregatorType(correlationExpression, aggregationStrategy);
        this.addOutput(answer);
        return answer;
    }

    public DelayerType delayer(Expression<Exchange> processAtExpression) {
        return this.delayer(processAtExpression, 0L);
    }

    public DelayerType delayer(Expression<Exchange> processAtExpression, long delay) {
        DelayerType answer = new DelayerType(processAtExpression, delay);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<DelayerType> delayer() {
        DelayerType answer = new DelayerType();
        this.addOutput(answer);
        return ExpressionClause.createAndSetExpression(answer);
    }

    public DelayerType delayer(long delay) {
        return this.delayer(null, delay);
    }

    public ThrottlerType throttler(long maximumRequestCount) {
        ThrottlerType answer = new ThrottlerType(maximumRequestCount);
        this.addOutput(answer);
        return answer;
    }

    public Type throwFault(Throwable fault) {
        ThrowFaultType answer = new ThrowFaultType();
        answer.setFault(fault);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type throwFault(String message) {
        return this.throwFault(new CamelException(message));
    }

    public Type interceptor(String ref) {
        InterceptorRef interceptor = new InterceptorRef(ref);
        this.addInterceptor(interceptor);
        return (Type)this;
    }

    public Type intercept(DelegateProcessor interceptor) {
        this.addInterceptor(new InterceptorRef(interceptor));
        this.lastInterceptor = interceptor;
        return (Type)this;
    }

    public InterceptType intercept() {
        InterceptType answer = new InterceptType();
        this.addOutput(answer);
        return answer;
    }

    public void addInterceptor(InterceptorType interceptor) {
        this.addOutput(interceptor);
        this.pushBlock(interceptor);
    }

    protected void pushBlock(Block block) {
        this.blocks.add(block);
    }

    protected Block popBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.removeLast();
    }

    public Type proceed() {
        ProceedType proceed = null;
        for (ProcessorType<? extends ProcessorType> node = this.parent; node != null; node = node.getParent()) {
            if (!(node instanceof InterceptType)) continue;
            InterceptType intercept = (InterceptType)node;
            proceed = intercept.getProceed();
            break;
        }
        if (proceed == null) {
            throw new IllegalArgumentException("Cannot use proceed() without being within an intercept() block");
        }
        this.addOutput(proceed);
        return (Type)this;
    }

    public ExceptionType exception(Class exceptionType) {
        ExceptionType answer = new ExceptionType(exceptionType);
        this.addOutput(answer);
        return answer;
    }

    public ChoiceType intercept(Predicate predicate) {
        InterceptType answer = new InterceptType();
        this.addOutput(answer);
        return answer.when(predicate);
    }

    public Type interceptors(String ... refs) {
        for (String ref : refs) {
            this.interceptor(ref);
        }
        return (Type)this;
    }

    public Type trace() {
        return this.trace(DEFAULT_TRACE_CATEGORY);
    }

    public Type trace(String category) {
        final Log log = LogFactory.getLog((String)category);
        return this.intercept(new DelegateProcessor(){

            public void process(Exchange exchange) throws Exception {
                log.trace((Object)exchange);
                this.processNext(exchange);
            }
        });
    }

    public PolicyRef policies() {
        PolicyRef answer = new PolicyRef();
        this.addOutput(answer);
        return answer;
    }

    public PolicyRef policy(Policy policy) {
        PolicyRef answer = new PolicyRef(policy);
        this.addOutput(answer);
        return answer;
    }

    public Type errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        return (Type)this;
    }

    public Type inheritErrorHandler(boolean condition) {
        this.setInheritErrorHandlerFlag(condition);
        return (Type)this;
    }

    public Type process(Processor processor) {
        ProcessorRef answer = new ProcessorRef(processor);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type processRef(String ref) {
        ProcessorRef answer = new ProcessorRef();
        answer.setRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean) {
        BeanRef answer = new BeanRef();
        answer.setBean(bean);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Object bean, String method) {
        BeanRef answer = new BeanRef();
        answer.setBean(bean);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType) {
        BeanRef answer = new BeanRef();
        answer.setBeanType(beanType);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type bean(Class beanType, String method) {
        BeanRef answer = new BeanRef();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref) {
        BeanRef answer = new BeanRef(ref);
        this.addOutput(answer);
        return (Type)this;
    }

    public Type beanRef(String ref, String method) {
        BeanRef answer = new BeanRef(ref, method);
        this.addOutput(answer);
        return (Type)this;
    }

    public ExpressionClause<ProcessorType<Type>> setBody() {
        ExpressionClause<ProcessorType<Type>> clause = new ExpressionClause<ProcessorType<Type>>(this);
        this.process(ProcessorBuilder.setBody(clause));
        return clause;
    }

    public Type setBody(Expression expression) {
        return this.process(ProcessorBuilder.setBody(expression));
    }

    public Type setOutBody(Expression expression) {
        return this.process(ProcessorBuilder.setOutBody(expression));
    }

    public ExpressionClause<ProcessorType<Type>> setOutBody() {
        ExpressionClause<ProcessorType<Type>> clause = new ExpressionClause<ProcessorType<Type>>(this);
        this.process(ProcessorBuilder.setOutBody(clause));
        return clause;
    }

    public Type setFaultBody(Expression expression) {
        return this.process(ProcessorBuilder.setFaultBody(expression));
    }

    public ExpressionClause<ProcessorType<Type>> setHeader(String name) {
        ExpressionClause<ProcessorType<Type>> clause = new ExpressionClause<ProcessorType<Type>>(this);
        this.process(ProcessorBuilder.setHeader(name, clause));
        return clause;
    }

    public Type setHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setHeader(name, expression));
    }

    public Type setHeader(String name, String value) {
        return (Type)this.setHeader(name).constant(value);
    }

    public ExpressionClause<ProcessorType<Type>> setOutHeader(String name) {
        ExpressionClause<ProcessorType<Type>> clause = new ExpressionClause<ProcessorType<Type>>(this);
        this.process(ProcessorBuilder.setOutHeader(name, clause));
        return clause;
    }

    public Type setOutHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setOutHeader(name, expression));
    }

    public Type setOutHeader(String name, String value) {
        return (Type)this.setOutHeader(name).constant(value);
    }

    public Type setFaultHeader(String name, Expression expression) {
        return this.process(ProcessorBuilder.setFaultHeader(name, expression));
    }

    public Type setProperty(String name, Expression expression) {
        return this.process(ProcessorBuilder.setProperty(name, expression));
    }

    public ExpressionClause<ProcessorType<Type>> setProperty(String name) {
        ExpressionClause<ProcessorType<Type>> clause = new ExpressionClause<ProcessorType<Type>>(this);
        this.process(ProcessorBuilder.setProperty(name, clause));
        return clause;
    }

    public Type removeHeader(String name) {
        return this.process(ProcessorBuilder.removeHeader(name));
    }

    public Type removeOutHeader(String name) {
        return this.process(ProcessorBuilder.removeOutHeader(name));
    }

    public Type removeFaultHeader(String name) {
        return this.process(ProcessorBuilder.removeFaultHeader(name));
    }

    public Type removeProperty(String name) {
        return this.process(ProcessorBuilder.removeProperty(name));
    }

    public Type convertBodyTo(Class type) {
        return this.process(new ConvertBodyProcessor(type));
    }

    public Type convertOutBodyTo(Class type) {
        return this.process(new ConvertBodyProcessor(type));
    }

    public Type convertFaultBodyTo(Class type) {
        return this.process(new ConvertBodyProcessor(type));
    }

    public DataFormatClause<ProcessorType<Type>> unmarshal() {
        return new DataFormatClause<ProcessorType<Type>>(this, DataFormatClause.Operation.Unmarshal);
    }

    public Type unmarshal(DataFormatType dataFormatType) {
        this.addOutput(new UnmarshalType(dataFormatType));
        return (Type)this;
    }

    public Type unmarshal(DataFormat dataFormat) {
        return this.unmarshal(new DataFormatType(dataFormat));
    }

    public Type unmarshal(String dataTypeRef) {
        this.addOutput(new UnmarshalType(dataTypeRef));
        return (Type)this;
    }

    public DataFormatClause<ProcessorType<Type>> marshal() {
        return new DataFormatClause<ProcessorType<Type>>(this, DataFormatClause.Operation.Marshal);
    }

    public Type marshal(DataFormatType dataFormatType) {
        this.addOutput(new MarshalType(dataFormatType));
        return (Type)this;
    }

    public Type marshal(DataFormat dataFormat) {
        return this.marshal(new DataFormatType(dataFormat));
    }

    public Type marshal(String dataTypeRef) {
        this.addOutput(new MarshalType(dataTypeRef));
        return (Type)this;
    }

    @XmlTransient
    public ProcessorType<? extends ProcessorType> getParent() {
        return this.parent;
    }

    public void setParent(ProcessorType<? extends ProcessorType> parent) {
        this.parent = parent;
    }

    @XmlTransient
    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @XmlTransient
    public boolean isInheritErrorHandler() {
        return ObjectConverter.toBoolean(this.getInheritErrorHandlerFlag());
    }

    @XmlAttribute(name="inheritErrorHandler", required=false)
    public Boolean getInheritErrorHandlerFlag() {
        return this.inheritErrorHandlerFlag;
    }

    public void setInheritErrorHandlerFlag(Boolean inheritErrorHandlerFlag) {
        this.inheritErrorHandlerFlag = inheritErrorHandlerFlag;
    }

    @XmlTransient
    public NodeFactory getNodeFactory() {
        if (this.nodeFactory == null) {
            this.nodeFactory = new NodeFactory();
        }
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public String getLabel() {
        return "";
    }

    protected Processor makeProcessor(RouteContext routeContext) throws Exception {
        Processor processor = this.createProcessor(routeContext);
        return this.wrapProcessor(routeContext, processor);
    }

    protected Processor wrapProcessorInInterceptors(RouteContext routeContext, Processor target) throws Exception {
        if (target == null) {
            throw new RuntimeCamelException("target provided.");
        }
        Object first = null;
        Object last = null;
        return first == null ? target : first;
    }

    protected Processor wrapInErrorHandler(Processor processor) throws Exception {
        return this.getErrorHandlerBuilder().createErrorHandler(processor);
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        if (this.isInheritErrorHandler()) {
            return new DeadLetterChannelBuilder();
        }
        return new NoErrorHandlerBuilder();
    }

    protected void configureChild(ProcessorType output) {
        output.setNodeFactory(this.getNodeFactory());
    }

    @Override
    public void addOutput(ProcessorType processorType) {
        processorType.setParent(this);
        this.configureChild(processorType);
        if (this.blocks.isEmpty()) {
            this.getOutputs().add(processorType);
        } else {
            Block block = this.blocks.getLast();
            block.addOutput(processorType);
        }
    }

    protected Processor createCompositeProcessor(List<Processor> list) {
        return new Pipeline(list);
    }

    protected Processor createOutputsProcessor(RouteContext routeContext, Collection<ProcessorType<?>> outputs) throws Exception {
        ArrayList<Processor> list = new ArrayList<Processor>();
        for (ProcessorType<?> output : outputs) {
            Processor processor = output.createProcessor(routeContext);
            list.add(processor);
        }
        Processor processor = null;
        if (!list.isEmpty()) {
            processor = list.size() == 1 ? (Processor)list.get(0) : this.createCompositeProcessor(list);
        }
        return processor;
    }

    public void clearOutput() {
        this.getOutputs().clear();
        this.blocks.clear();
    }
}

