/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.OutputType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.dataformat.ArtixDSDataFormat;
import org.apache.camel.model.dataformat.CsvDataFormat;
import org.apache.camel.model.dataformat.DataFormatType;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.model.dataformat.SerializationDataFormat;
import org.apache.camel.model.dataformat.StringDataFormat;
import org.apache.camel.model.dataformat.XMLBeansDataFormat;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.spi.DataFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="marshal")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MarshalType
extends OutputType<ProcessorType> {
    @XmlAttribute(required=false)
    private String ref;
    @XmlElements(value={@XmlElement(required=false, name="artixDS", type=ArtixDSDataFormat.class), @XmlElement(required=false, name="csv", type=CsvDataFormat.class), @XmlElement(required=false, name="jaxb", type=JaxbDataFormat.class), @XmlElement(required=false, name="serialization", type=SerializationDataFormat.class), @XmlElement(required=false, name="string", type=StringDataFormat.class), @XmlElement(required=false, name="xmlBeans", type=XMLBeansDataFormat.class)})
    private DataFormatType dataFormatType;

    public MarshalType() {
    }

    public MarshalType(DataFormatType dataFormatType) {
        this.dataFormatType = dataFormatType;
    }

    public MarshalType(String ref) {
        this.ref = ref;
    }

    public String toString() {
        if (this.dataFormatType != null) {
            return "Marshal[" + this.dataFormatType + "]";
        }
        return "Marshal[ref:  " + this.ref + "]";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public DataFormatType getDataFormatType() {
        return this.dataFormatType;
    }

    public void setDataFormatType(DataFormatType dataFormatType) {
        this.dataFormatType = dataFormatType;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        DataFormat dataFormat = DataFormatType.getDataFormat(routeContext, this.getDataFormatType(), this.ref);
        return new MarshalProcessor(dataFormat);
    }
}

