

package org.jfree.data.hc.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jfree.data.hc.DataRange;
import org.jfree.data.hc.DataRangeMismatchException;

/**
 * Some tests for the <code>org.jfree.data</code> package that can be run 
 * using JUnit.  You can find more information about JUnit at 
 * <a href="http://www.junit.org">http://www.junit.org</a>.
 */
public class DataRangeTests extends TestCase {

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public DataRangeTests(String name) {
        super(name);
    }

    /**
     * Returns a test suite to the JUnit test runner.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(DataRangeTests.class);
    }

    /**
     * Runs the test suite using JUnit's text-based runner.
     * 
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    /**
     * Tests all methods with non empty data ranges.
     * The nethods to test are:
     *	public DataRange(int leftBound, int rightBound),
     *	public boolean isEmpty(),
     *	public int getLeftBound(),
     *	public int getRightBound(),
     *	public String toString(),
     *	public int getWidth(),
     *	public boolean contains(DataRange that),
     *	public boolean contains(int index),
     *	public void add(DataRange range) throws DataRangeMismatchException,
     *	public Object clone() and
     *	public boolean equals(DataRange range)
     */
    public void testNonEmptyDataRanges() throws DataRangeMismatchException {

	DataRange dr = new DataRange(1,3);
	DataRange dr0 = new DataRange(0,-1);
	DataRange dr2;

	assertFalse(dr.isEmpty());
	assertTrue(dr.getLeftBound() == 1);
	assertTrue(dr.getRightBound() == 3);
	assertTrue(dr.toString().equals("[1,3]"));
	assertTrue(dr.getWidth() == 3);

	assertFalse(dr.contains(0));
	assertTrue(dr.contains(1));
	assertTrue(dr.contains(2));
	assertTrue(dr.contains(3));
	assertFalse(dr.contains(4));

	assertTrue(dr.contains(dr));
	assertTrue(dr.contains(dr0));
	assertTrue(dr.contains(new DataRange(2,2)));
	assertFalse(dr.contains(new DataRange(2,4)));
	assertFalse(dr.contains(new DataRange(0,2)));

	dr2 = (DataRange)dr.clone();
	assertFalse(dr2 == dr);
	assertTrue(dr.equals(dr2));
	assertTrue(dr2.equals(dr));

	assertTrue(dr.equals(dr));
	assertFalse(dr.equals(dr0));
	assertFalse(dr.equals(new DataRange(2,3)));
	assertFalse(dr.equals(new DataRange(1,2)));

	// add
	dr2.add(dr2);
	assertTrue(dr2.equals(dr2));
	dr2.add(new DataRange(2,4));
	assertTrue(dr2.equals(new DataRange(1,4)));
	dr2.add(new DataRange(0,2));
	assertTrue(dr2.equals(new DataRange(0,4)));

	try {
	    dr2.add(new DataRange(10,15));
	    assertTrue(false);
	} catch (DataRangeMismatchException e) {
	    ;
	}

	try {
	    dr2.add(new DataRange(-5,-2));
	    assertTrue(false);
	} catch (DataRangeMismatchException e) {
	    ;
	}

    }

    /**
     * Tests all methods with non empty data ranges.
     * The nethods to test are:
     *	public DataRange(int leftBound, int rightBound),
     *	public boolean isEmpty(),
     *	public int getLeftBound(),
     *	public int getRightBound(),
     *	public String toString(),
     *	public int getWidth(),
     *	public boolean contains(DataRange that),
     *	public boolean contains(int index),
     *	public void add(DataRange range) throws DataRangeMismatchException,
     *	public Object clone() and
     *	public boolean equals(DataRange range)
     */
    public void testEmptyDataRanges() {

	// we first test creating two empty data ranges in different ways.
	DataRange dr = new DataRange(0,-1);
	DataRange dr2 = new DataRange(5,-5);
	DataRange dr3;

	assertTrue(dr.isEmpty());
	try {
	    dr.getLeftBound();
	    assertTrue(false);
	} catch (RuntimeException e) {
	    ;
	}
	try {
	    dr.getRightBound();
	    assertTrue(false);
	} catch (RuntimeException e) {
	    ;
	}
	assertTrue(dr.toString() == "[]");
	assertTrue(dr.getWidth() == 0);
	assertFalse(dr.contains(0));

	dr3 = (DataRange)dr.clone();
	assertFalse(dr3 == dr);
	assertTrue(dr.equals(dr3));
	assertTrue(dr3.equals(dr));

	assertTrue(dr.equals(dr2));
	assertTrue(dr2.equals(dr));

	assertTrue(dr.equals(dr));

	assertTrue(dr.contains(dr2));
	assertFalse(dr.contains(new DataRange(0,0)));

	try {
	    dr.add(dr2);
	    assertTrue(dr.equals(dr2)); // empty+empty=empty
	} catch (DataRangeMismatchException e) {
	    assertTrue(false);
	}

    }

}

