/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.component.jms.RuntimeJmsException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmsBinding {
    private static final transient Log LOG = LogFactory.getLog(JmsBinding.class);
    private Set<String> ignoreJmsHeaders;
    private XmlConverter xmlConverter = new XmlConverter();

    public Object extractBodyFromJms(Exchange exchange, javax.jms.Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                return objectMessage.getObject();
            }
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return textMessage.getText();
            }
            if (message instanceof MapMessage) {
                return this.createMapFromMapMessage((MapMessage)message);
            }
            if (message instanceof BytesMessage) {
                return this.createByteArrayFromBytesMessage((BytesMessage)message);
            }
            if (message instanceof StreamMessage) {
                return message;
            }
            return null;
        }
        catch (JMSException e) {
            throw new RuntimeJmsException("Failed to extract body due to: " + (Object)((Object)e) + ". Message: " + message, e);
        }
    }

    protected byte[] createByteArrayFromBytesMessage(BytesMessage message) throws JMSException {
        if (message.getBodyLength() > Integer.MAX_VALUE) {
            return null;
        }
        byte[] result = new byte[(int)message.getBodyLength()];
        message.readBytes(result);
        return result;
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Session session) throws JMSException {
        return this.makeJmsMessage(exchange, exchange.getIn(), session);
    }

    public javax.jms.Message makeJmsMessage(Exchange exchange, Message camelMessage, Session session) throws JMSException {
        javax.jms.Message answer = null;
        if (camelMessage instanceof JmsMessage) {
            JmsMessage jmsMessage = (JmsMessage)camelMessage;
            answer = jmsMessage.getJmsMessage();
        }
        if (answer == null) {
            answer = this.createJmsMessage(camelMessage.getBody(), session, exchange.getContext());
            this.appendJmsProperties(answer, exchange, camelMessage);
        }
        return answer;
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange) throws JMSException {
        this.appendJmsProperties(jmsMessage, exchange, exchange.getIn());
    }

    public void appendJmsProperties(javax.jms.Message jmsMessage, Exchange exchange, Message in) throws JMSException {
        Set entries = in.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            String headerName = (String)entry.getKey();
            Object headerValue = entry.getValue();
            if (headerName.startsWith("JMS") && !headerName.startsWith("JMSX")) {
                if (headerName.equals("JMSCorrelationID")) {
                    jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                    continue;
                }
                if (headerName.equals("JMSCorrelationID")) {
                    jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                    continue;
                }
                if (headerName.equals("JMSReplyTo")) {
                    jmsMessage.setJMSReplyTo((Destination)ExchangeHelper.convertToType((Exchange)exchange, Destination.class, headerValue));
                    continue;
                }
                if (headerName.equals("JMSType")) {
                    jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignoring JMS header: " + headerName + " with value: " + headerValue));
                continue;
            }
            if (!this.shouldOutputHeader(in, headerName, headerValue)) continue;
            jmsMessage.setObjectProperty(headerName, headerValue);
        }
    }

    protected javax.jms.Message createJmsMessage(Object body, Session session, CamelContext context) throws JMSException {
        if (body instanceof Node) {
            try {
                body = this.xmlConverter.toString((Node)body);
            }
            catch (TransformerException e) {
                JMSException jmsException = new JMSException(e.getMessage());
                jmsException.setLinkedException((Exception)e);
                throw jmsException;
            }
        }
        if (body instanceof byte[]) {
            BytesMessage result = session.createBytesMessage();
            result.writeBytes((byte[])body);
            return result;
        }
        if (body instanceof Map) {
            MapMessage result = session.createMapMessage();
            Map map = (Map)body;
            try {
                this.populateMapMessage(result, map, context);
                return result;
            }
            catch (JMSException e) {
                // empty catch block
            }
        }
        if (body instanceof String) {
            return session.createTextMessage((String)body);
        }
        if (body instanceof Serializable) {
            return session.createObjectMessage((Serializable)body);
        }
        return session.createMessage();
    }

    protected void populateMapMessage(MapMessage message, Map<?, ?> map, CamelContext context) throws JMSException {
        for (Object key : map.keySet()) {
            String keyString = (String)CamelContextHelper.convertTo((CamelContext)context, String.class, key);
            if (keyString == null) continue;
            message.setObject(keyString, map.get(key));
        }
    }

    public Map<String, Object> createMapFromMapMessage(MapMessage message) throws JMSException {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            Object value = message.getObject(name);
            answer.put(name, value);
        }
        return answer;
    }

    public Set<String> getIgnoreJmsHeaders() {
        if (this.ignoreJmsHeaders == null) {
            this.ignoreJmsHeaders = new HashSet<String>();
            this.populateIgnoreJmsHeaders(this.ignoreJmsHeaders);
        }
        return this.ignoreJmsHeaders;
    }

    public void setIgnoreJmsHeaders(Set<String> ignoreJmsHeaders) {
        this.ignoreJmsHeaders = ignoreJmsHeaders;
    }

    protected boolean shouldOutputHeader(Message camelMessage, String headerName, Object headerValue) {
        return headerValue != null && !this.getIgnoreJmsHeaders().contains(headerName) && ObjectHelper.isJavaIdentifier((String)headerName);
    }

    protected void populateIgnoreJmsHeaders(Set<String> set) {
        String[] ignore = new String[]{"JMSXUserID", "JMSXAppID", "JMSXDeliveryCount", "JMSXProducerTXID", "JMSXConsumerTXID", "JMSXRcvTimestamp", "JMSXState"};
        set.addAll(Arrays.asList(ignore));
    }
}

