/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.UIManager;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIManagerExt {
    private static UIDefaultsExt uiDefaultsExt = new UIDefaultsExt();

    private UIManagerExt() {
    }

    public static void addResourceBundle(String bundleName) {
        uiDefaultsExt.addResourceBundle(bundleName);
    }

    public static void removeResourceBundle(String bundleName) {
        uiDefaultsExt.removeResourceBundle(bundleName);
    }

    public static String getString(Object key) {
        return UIManagerExt.getString(key, null);
    }

    public static String getString(Object key, Locale l) {
        String value = UIManager.getString(key, l);
        if (value == null) {
            value = (String)UIManagerExt.uiDefaultsExt.getFromResourceBundle(key, l);
        }
        return value;
    }

    public static Painter<?> getPainter(Object key) {
        Object value = UIManager.getDefaults().get(key);
        return value instanceof Painter ? (Painter)value : null;
    }

    public static Painter<?> getPainter(Object key, Locale l) {
        Object value = UIManager.getDefaults().get(key, l);
        return value instanceof Painter ? (Painter)value : null;
    }

    public static Color getSafeColor(Object key, Color defaultColor) {
        Contract.asNotNull(defaultColor, "defaultColor cannot be null");
        Color safeColor = UIManager.getColor(key);
        if (safeColor == null) {
            safeColor = defaultColor;
        }
        return safeColor;
    }

    public static Font getSafeFont(Object key, Font defaultFont) {
        Contract.asNotNull(defaultFont, "defaultFont cannot be null");
        Font safeFont = UIManager.getFont(key);
        if (safeFont == null) {
            safeFont = defaultFont;
        }
        return safeFont;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UIDefaultsExt {
        private Vector<String> resourceBundles;
        private Map<Locale, Map<String, String>> resourceCache = new HashMap<Locale, Map<String, String>>();

        UIDefaultsExt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getFromResourceBundle(Object key, Locale l) {
            if (this.resourceBundles == null || this.resourceBundles.isEmpty() || !(key instanceof String)) {
                return null;
            }
            if (l == null) {
                l = Locale.getDefault();
            }
            UIDefaultsExt uIDefaultsExt = this;
            synchronized (uIDefaultsExt) {
                return this.getResourceCache(l).get((String)key);
            }
        }

        private Map<String, String> getResourceCache(Locale l) {
            Map<String, String> values = this.resourceCache.get(l);
            if (values == null) {
                values = new HashMap<String, String>();
                for (int i = this.resourceBundles.size() - 1; i >= 0; --i) {
                    String bundleName = this.resourceBundles.get(i);
                    try {
                        ResourceBundle b = ResourceBundle.getBundle(bundleName, l, UIManagerExt.class.getClassLoader());
                        Enumeration<String> keys = b.getKeys();
                        while (keys.hasMoreElements()) {
                            String key = keys.nextElement();
                            if (values.get(key) != null) continue;
                            Object value = b.getObject(key);
                            values.put(key, (String)value);
                        }
                        continue;
                    }
                    catch (MissingResourceException mre) {
                        // empty catch block
                    }
                }
                this.resourceCache.put(l, values);
            }
            return values;
        }

        public synchronized void addResourceBundle(String bundleName) {
            if (bundleName == null) {
                return;
            }
            if (this.resourceBundles == null) {
                this.resourceBundles = new Vector(5);
            }
            if (!this.resourceBundles.contains(bundleName)) {
                this.resourceBundles.add(bundleName);
                this.resourceCache.clear();
            }
        }

        public synchronized void removeResourceBundle(String bundleName) {
            if (this.resourceBundles != null) {
                this.resourceBundles.remove(bundleName);
            }
            this.resourceCache.clear();
        }
    }
}

