/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Toolkit;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPaneContainerAddon
extends AbstractComponentAddon {
    public TaskPaneContainerAddon() {
        super("JXTaskPaneContainer");
    }

    @Override
    protected void addBasicDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addBasicDefaults(addon, defaults);
        defaults.addAll(Arrays.asList("swingx/TaskPaneContainerUI", "org.jdesktop.swingx.plaf.basic.BasicTaskPaneContainerUI", "TaskPaneContainer.background", UIManagerExt.getSafeColor("Desktop.background", new ColorUIResource(Color.decode("#005C5C"))), "TaskPaneContainer.border", new BorderUIResource(BorderFactory.createEmptyBorder(10, 10, 0, 10))));
    }

    @Override
    protected void addMetalDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addMetalDefaults(addon, defaults);
        defaults.addAll(Arrays.asList("TaskPaneContainer.background", MetalLookAndFeel.getDesktopColor()));
    }

    @Override
    protected void addWindowsDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addWindowsDefaults(addon, defaults);
        if (addon instanceof WindowsClassicLookAndFeelAddons) {
            defaults.addAll(Arrays.asList("TaskPaneContainer.background", UIManagerExt.getSafeColor("List.background", new ColorUIResource(Color.decode("#005C5C")))));
        } else if (addon instanceof WindowsLookAndFeelAddons) {
            Color backgroundGradientEnd;
            Color backgroundGradientStart;
            ColorUIResource background;
            String xpStyle = OS.getWindowsVisualStyle();
            if ("HomeStead".equalsIgnoreCase(xpStyle)) {
                background = new ColorUIResource(201, 215, 170);
                backgroundGradientStart = new Color(204, 217, 173);
                backgroundGradientEnd = new Color(165, 189, 132);
            } else if ("Metallic".equalsIgnoreCase(xpStyle)) {
                background = new ColorUIResource(192, 195, 209);
                backgroundGradientStart = new Color(196, 200, 212);
                backgroundGradientEnd = new Color(177, 179, 200);
            } else if (OS.isWindowsVista()) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                background = new ColorUIResource((Color)toolkit.getDesktopProperty("win.3d.backgroundColor"));
                backgroundGradientStart = (Color)toolkit.getDesktopProperty("win.frame.activeCaptionColor");
                backgroundGradientEnd = (Color)toolkit.getDesktopProperty("win.frame.inactiveCaptionColor");
            } else {
                background = new ColorUIResource(117, 150, 227);
                backgroundGradientStart = new ColorUIResource(123, 162, 231);
                backgroundGradientEnd = new ColorUIResource(99, 117, 214);
            }
            defaults.addAll(Arrays.asList("TaskPaneContainer.backgroundPainter", new PainterUIResource(new MattePainter(new GradientPaint(0.0f, 0.0f, backgroundGradientStart, 0.0f, 1.0f, backgroundGradientEnd), true)), "TaskPaneContainer.background", background));
        }
    }

    @Override
    protected void addMacDefaults(LookAndFeelAddons addon, List<Object> defaults) {
        super.addMacDefaults(addon, defaults);
        defaults.addAll(Arrays.asList("TaskPaneContainer.background", new ColorUIResource(238, 238, 238)));
    }
}

