/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.RolloverRenderer;
import org.jdesktop.swingx.action.LinkAction;

public class LinkRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ListCellRenderer,
TreeCellRenderer,
RolloverRenderer {
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private JXHyperlink linkButton = this.createHyperlink();
    private LinkAction<Object> linkAction;
    protected Class<?> targetClass;

    public LinkRenderer() {
        this(null, null);
    }

    public LinkRenderer(LinkAction linkAction) {
        this(linkAction, null);
    }

    public LinkRenderer(LinkAction linkAction, Class targetClass) {
        this.linkButton.addActionListener(this.createEditorActionListener());
        this.setLinkAction(linkAction, targetClass);
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setLinkAction(LinkAction linkAction) {
        this.setLinkAction(linkAction, null);
    }

    public void setLinkAction(LinkAction linkAction, Class targetClass) {
        if (linkAction == null) {
            linkAction = this.createDefaultLinkAction();
        }
        this.setTargetClass(targetClass);
        this.linkAction = linkAction;
        this.linkButton.setAction(linkAction);
    }

    public boolean isTargetable(Object target) {
        if (this.targetClass == null) {
            return true;
        }
        if (target == null) {
            return true;
        }
        return this.targetClass.isAssignableFrom(target.getClass());
    }

    protected JXHyperlink createHyperlink() {
        return new JXHyperlink(){

            public void updateUI() {
                super.updateUI();
                this.setBorderPainted(true);
                this.setOpaque(true);
            }
        };
    }

    protected LinkAction createDefaultLinkAction() {
        return new LinkAction<Object>(null){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
    }

    public boolean isEnabled() {
        return true;
    }

    public void doClick() {
        this.linkButton.doClick();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null && !this.isTargetable(value)) {
            value = null;
        }
        this.linkAction.setTarget(value);
        if (list != null) {
            Point p = (Point)list.getClientProperty("swingx.rollover");
            if (p != null && p.y >= 0 && p.y == index) {
                this.linkButton.getModel().setRollover(true);
            } else {
                this.linkButton.getModel().setRollover(false);
            }
            this.updateSelectionColors(list, isSelected);
            this.updateFocusBorder(cellHasFocus);
        }
        return this.linkButton;
    }

    private void updateSelectionColors(JList table, boolean isSelected) {
        if (isSelected) {
            this.linkButton.setBackground(table.getSelectionBackground());
        } else {
            this.linkButton.setBackground(table.getBackground());
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null && !this.isTargetable(value)) {
            value = null;
        }
        this.linkAction.setTarget(value);
        if (table != null) {
            Point p = (Point)table.getClientProperty("swingx.rollover");
            if (p != null && p.x >= 0 && p.x == column && p.y == row) {
                this.linkButton.getModel().setRollover(true);
            } else {
                this.linkButton.getModel().setRollover(false);
            }
            this.updateSelectionColors(table, isSelected);
            this.updateFocusBorder(hasFocus);
        }
        return this.linkButton;
    }

    private void updateSelectionColors(JTable table, boolean isSelected) {
        if (isSelected) {
            this.linkButton.setBackground(table.getSelectionBackground());
        } else {
            this.linkButton.setBackground(table.getBackground());
        }
    }

    private void updateFocusBorder(boolean hasFocus) {
        if (hasFocus) {
            this.linkButton.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.linkButton.setBorder(noFocusBorder);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.linkAction.setTarget(value);
        this.linkButton.getModel().setRollover(true);
        this.updateSelectionColors(table, isSelected);
        return this.linkButton;
    }

    public Object getCellEditorValue() {
        return this.linkAction.getTarget();
    }

    protected void fireEditingStopped() {
        this.fireEditingCanceled();
    }

    private ActionListener createEditorActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LinkRenderer.this.cancelCellEditing();
            }
        };
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null && !this.isTargetable(value)) {
            value = null;
        }
        this.linkAction.setTarget(value);
        if (tree != null) {
            Point p = (Point)tree.getClientProperty("swingx.rollover");
            if (p != null && p.y >= 0 && p.y == row) {
                this.linkButton.getModel().setRollover(true);
            } else {
                this.linkButton.getModel().setRollover(false);
            }
            this.updateSelectionColors(tree, isSelected);
            this.updateFocusBorder(hasFocus);
        }
        return this.linkButton;
    }

    private void updateSelectionColors(JTree tree, boolean isSelected) {
        if (isSelected) {
            this.linkButton.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.linkButton.setBackground(tree.getBackground());
        }
    }
}

