/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jpa;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.jpa.JPAMessageStore;
import org.apache.activemq.store.jpa.JPATopicMessageStore;
import org.apache.activemq.store.memory.MemoryTransactionStore;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAPersistenceAdapter
implements PersistenceAdapter {
    String entityManagerName = "activemq";
    Properties entityManagerProperties = System.getProperties();
    EntityManagerFactory entityManagerFactory;
    private WireFormat wireFormat;
    private MemoryTransactionStore transactionStore;

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        if (context.getLongTermStoreContext() != null) {
            throw new IOException("Transation already started.");
        }
        EntityManager manager = this.getEntityManagerFactory().createEntityManager();
        manager.getTransaction().begin();
        context.setLongTermStoreContext(manager);
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        EntityManager manager = (EntityManager)context.getLongTermStoreContext();
        if (manager == null) {
            throw new IOException("Transation not started.");
        }
        context.setLongTermStoreContext(null);
        manager.getTransaction().commit();
        manager.close();
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        EntityManager manager = (EntityManager)context.getLongTermStoreContext();
        if (manager == null) {
            throw new IOException("Transation not started.");
        }
        context.setLongTermStoreContext(null);
        manager.getTransaction().rollback();
        manager.close();
    }

    public EntityManager beginEntityManager(ConnectionContext context) {
        if (context == null || context.getLongTermStoreContext() == null) {
            EntityManager manager = this.getEntityManagerFactory().createEntityManager();
            manager.getTransaction().begin();
            return manager;
        }
        return (EntityManager)context.getLongTermStoreContext();
    }

    public void commitEntityManager(ConnectionContext context, EntityManager manager) {
        if (context == null || context.getLongTermStoreContext() == null) {
            manager.getTransaction().commit();
            manager.close();
        }
    }

    public void rollbackEntityManager(ConnectionContext context, EntityManager manager) {
        if (context == null || context.getLongTermStoreContext() == null) {
            manager.getTransaction().rollback();
            manager.close();
        }
    }

    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = new JPAMessageStore(this, destination);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = new JPATopicMessageStore(this, destination);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore();
        }
        return this.transactionStore;
    }

    @Override
    public void deleteAllMessages() throws IOException {
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("delete from StoredMessage m");
            query.executeUpdate();
            query = manager.createQuery("delete from StoredSubscription ss");
            query.executeUpdate();
        }
        catch (Throwable e) {
            this.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create(e);
        }
        this.commitEntityManager(null, manager);
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select distinct m.destination from StoredMessage m");
            for (String dest : query.getResultList()) {
                rc.add(ActiveMQDestination.createDestination(dest, (byte)1));
            }
        }
        catch (RuntimeException e) {
            this.rollbackEntityManager(null, manager);
            throw e;
        }
        this.commitEntityManager(null, manager);
        return rc;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        long rc = 0L;
        EntityManager manager = this.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select max(m.id) from StoredMessage m");
            Long t = (Long)query.getSingleResult();
            if (t != null) {
                rc = t;
            }
        }
        catch (Throwable e) {
            this.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create(e);
        }
        this.commitEntityManager(null, manager);
        return rc;
    }

    public boolean isUseExternalMessageReferences() {
        return false;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.createEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.getEntityManagerName(), (Map)this.getEntityManagerProperties());
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public Properties getEntityManagerProperties() {
        return this.entityManagerProperties;
    }

    public void setEntityManagerProperties(Properties entityManagerProperties) {
        this.entityManagerProperties = entityManagerProperties;
    }

    public String getEntityManagerName() {
        return this.entityManagerName;
    }

    public void setEntityManagerName(String entityManager) {
        this.entityManagerName = entityManager;
    }

    public WireFormat getWireFormat() {
        if (this.wireFormat == null) {
            this.wireFormat = this.createWireFormat();
        }
        return this.wireFormat;
    }

    private WireFormat createWireFormat() {
        OpenWireFormatFactory wff = new OpenWireFormatFactory();
        return wff.createWireFormat();
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    @Override
    public void checkpoint(boolean sync) throws IOException {
    }

    @Override
    public void setBrokerName(String brokerName) {
    }

    @Override
    public void setDirectory(File dir2) {
    }

    @Override
    public long size() {
        return 0L;
    }
}

