/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.DataFile;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.async.ReadOnlyDataFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyAsyncDataManager
extends AsyncDataManager {
    private static final Log LOG = LogFactory.getLog(ReadOnlyAsyncDataManager.class);
    private final ArrayList<File> dirs;

    public ReadOnlyAsyncDataManager(ArrayList<File> dirs) {
        this.dirs = dirs;
    }

    @Override
    public synchronized void start() throws IOException {
        Location l;
        if (this.started) {
            return;
        }
        this.started = true;
        ArrayList<File> files = new ArrayList<File>();
        Iterator<File> i$ = this.dirs.iterator();
        while (i$.hasNext()) {
            File directory;
            final File d = directory = i$.next();
            File[] f = d.listFiles(new FilenameFilter(){

                public boolean accept(File dir2, String n) {
                    return dir2.equals(d) && n.startsWith(ReadOnlyAsyncDataManager.this.filePrefix);
                }
            });
            for (int i = 0; i < f.length; ++i) {
                files.add(f[i]);
            }
        }
        for (File file : files) {
            try {
                String n = file.getName();
                String numStr = n.substring(this.filePrefix.length(), n.length());
                int num = Integer.parseInt(numStr);
                ReadOnlyDataFile dataFile = new ReadOnlyDataFile(file, num, this.preferedFileLength);
                this.fileMap.put(dataFile.getDataFileId(), dataFile);
                this.storeSize.addAndGet(dataFile.getLength());
            }
            catch (NumberFormatException e) {}
        }
        ArrayList dataFiles = new ArrayList(this.fileMap.values());
        Collections.sort(dataFiles);
        this.currentWriteFile = null;
        for (DataFile df : dataFiles) {
            if (this.currentWriteFile != null) {
                this.currentWriteFile.linkAfter(df);
            }
            this.currentWriteFile = df;
            this.fileByFileMap.put(df.getFile(), df);
        }
        if (this.currentWriteFile != null && (l = (Location)this.lastAppendLocation.get()) != null && l.getDataFileId() != this.currentWriteFile.getDataFileId().intValue()) {
            Object var3_3 = null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.started) {
            return;
        }
        this.accessorPool.close();
        this.fileMap.clear();
        this.fileByFileMap.clear();
        this.started = false;
    }

    public Location getFirstLocation() throws IllegalStateException, IOException {
        if (this.currentWriteFile == null) {
            return null;
        }
        DataFile first = (DataFile)this.currentWriteFile.getHeadNode();
        Location cur = new Location();
        cur.setDataFileId(first.getDataFileId());
        cur.setOffset(0);
        cur.setSize(0);
        return this.getNextLocation(cur);
    }

    @Override
    public synchronized boolean delete() throws IOException {
        throw new RuntimeException("Cannot delete a ReadOnlyAsyncDataManager");
    }
}

