/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;

public class RecoveryBrokerTest
extends BrokerRestartTestSupport {
    public void XtestWildCardSubscriptionPreservedOnRestart() throws Exception {
        Message m2;
        Message m;
        int i;
        ActiveMQTopic dest1 = new ActiveMQTopic("TEST.A");
        ActiveMQTopic dest2 = new ActiveMQTopic("TEST.B");
        ActiveMQTopic dest3 = new ActiveMQTopic("TEST.C");
        ActiveMQTopic wildDest = new ActiveMQTopic("TEST.>");
        ArrayList<MessageId> sentBeforeRestart = new ArrayList<MessageId>();
        ArrayList<MessageId> sentBeforeCreateConsumer = new ArrayList<MessageId>();
        ArrayList<MessageId> sentAfterCreateConsumer = new ArrayList<MessageId>();
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        connectionInfo1.setClientId("A");
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send(connectionInfo1);
        connection1.send(sessionInfo1);
        connection1.send(producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, wildDest);
        consumerInfo1.setSubscriptionName("test");
        consumerInfo1.setPrefetchSize(100);
        connection1.send(consumerInfo1);
        connection1.send(this.closeConsumerInfo(consumerInfo1));
        for (i = 0; i < 4; ++i) {
            m = this.createMessage(producerInfo1, dest1, 2);
            connection1.send(m);
            sentBeforeRestart.add(m.getMessageId());
        }
        connection1.request(this.closeConnectionInfo(connectionInfo1));
        connection1.stop();
        this.restartBroker();
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        connectionInfo2.setClientId("A");
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send(connectionInfo2);
        connection2.send(sessionInfo2);
        ProducerInfo producerInfo2 = this.createProducerInfo(sessionInfo2);
        connection2.send(producerInfo2);
        for (int i2 = 0; i2 < 4; ++i2) {
            Message m3 = this.createMessage(producerInfo2, dest2, 2);
            connection2.send(m3);
            sentBeforeCreateConsumer.add(m3.getMessageId());
        }
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, wildDest);
        consumerInfo2.setSubscriptionName("test");
        consumerInfo2.setPrefetchSize(100);
        connection2.send(consumerInfo2);
        for (i = 0; i < 4; ++i) {
            m = this.createMessage(producerInfo2, dest3, 2);
            connection2.send(m);
            sentAfterCreateConsumer.add(m.getMessageId());
        }
        for (i = 0; i < 4; ++i) {
            m2 = this.receiveMessage(connection2);
            RecoveryBrokerTest.assertNotNull((String)("Recovered message missing: " + i), (Object)m2);
            RecoveryBrokerTest.assertEquals(sentBeforeRestart.get(i), (Object)m2.getMessageId());
        }
        for (i = 0; i < 4; ++i) {
            m2 = this.receiveMessage(connection2);
            RecoveryBrokerTest.assertNotNull((String)("Before activated message missing: " + i), (Object)m2);
            RecoveryBrokerTest.assertEquals(sentBeforeCreateConsumer.get(i), (Object)m2.getMessageId());
        }
        for (i = 0; i < 4; ++i) {
            m2 = this.receiveMessage(connection2);
            RecoveryBrokerTest.assertNotNull((String)("After activated message missing: " + i), (Object)m2);
            RecoveryBrokerTest.assertEquals((String)("" + i), sentAfterCreateConsumer.get(i), (Object)m2.getMessageId());
        }
        this.assertNoMessagesLeft(connection2);
    }

    public void testConsumedQueuePersistentMessagesLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            connection.send(message);
        }
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        for (int i = 0; i < 4; ++i) {
            Message m2 = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m2);
        }
        this.restartBroker();
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNull((Object)m);
    }

    public void testQueuePersistentUncommitedMessagesLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            message.setTransactionId(txid);
            connection.send(message);
        }
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNull((Object)m);
    }

    public void testTopicDurableConsumerHoldsPersistentMessageAfterRestart() throws Exception {
        ActiveMQTopic destination = new ActiveMQTopic("TEST");
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        connectionInfo1.setClientId("A");
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo1 = this.createProducerInfo(sessionInfo1);
        connection1.send(connectionInfo1);
        connection1.send(sessionInfo1);
        connection1.send(producerInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, destination);
        consumerInfo1.setSubscriptionName("test");
        consumerInfo1.setPrefetchSize(100);
        connection1.send(consumerInfo1);
        connection1.send(this.closeConsumerInfo(consumerInfo1));
        connection1.send(this.createMessage(producerInfo1, destination, 2));
        connection1.send(this.createMessage(producerInfo1, destination, 2));
        connection1.send(this.createMessage(producerInfo1, destination, 2));
        connection1.send(this.createMessage(producerInfo1, destination, 2));
        connection1.request(this.closeConnectionInfo(connectionInfo1));
        this.restartBroker();
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        connectionInfo2.setClientId("A");
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send(connectionInfo2);
        connection2.send(sessionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, destination);
        consumerInfo2.setSubscriptionName("test");
        consumerInfo2.setPrefetchSize(100);
        connection2.send(consumerInfo2);
        for (int i = 0; i < 4; ++i) {
            Message m2 = this.receiveMessage(connection2);
            RecoveryBrokerTest.assertNotNull((String)("Did not get message " + i), (Object)m2);
        }
        this.assertNoMessagesLeft(connection2);
    }

    public void testQueuePersistentMessagesNotLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        Message message = this.createMessage(producerInfo, destination);
        message.setPersistent(true);
        connection.send(message);
        connection.request(this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNotNull((String)"Should have received a message by now!", (Object)m);
        RecoveryBrokerTest.assertEquals((Object)m.getMessageId(), (Object)message.getMessageId());
    }

    public void testQueueNonPersistentMessagesLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        Message message = this.createMessage(producerInfo, destination);
        message.setPersistent(false);
        connection.send(message);
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        this.assertNoMessagesLeft(connection);
    }

    public void testQueuePersistentCommitedMessagesNotLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            message.setTransactionId(txid);
            connection.send(message);
        }
        connection.send(this.createCommitTransaction1Phase(connectionInfo, txid));
        connection.request(this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public void testQueuePersistentCommitedAcksNotLostOnRestart() throws Exception {
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        for (int i = 0; i < 4; ++i) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            connection.send(message);
        }
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (int i = 0; i < 4; ++i) {
            Message m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
            MessageAck ack = this.createAck(consumerInfo, m, 1, (byte)2);
            ack.setTransactionId(txid);
            connection.send(ack);
        }
        connection.send(this.createCommitTransaction1Phase(connectionInfo, txid));
        connection.request(this.closeConnectionInfo(connectionInfo));
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        Message m = this.receiveMessage(connection);
        RecoveryBrokerTest.assertNull((Object)m);
    }

    public void testQueuePersistentUncommitedAcksLostOnRestart() throws Exception {
        Message m;
        int i;
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        connection.send(producerInfo);
        for (int i2 = 0; i2 < 4; ++i2) {
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            connection.send(message);
        }
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send(this.createBeginTransaction(connectionInfo, txid));
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
            MessageAck ack = this.createAck(consumerInfo, m, 1, (byte)2);
            ack.setTransactionId(txid);
            connection.send(ack);
        }
        this.restartBroker();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send(connectionInfo);
        connection.send(sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send(consumerInfo);
        for (i = 0; i < 4; ++i) {
            m = this.receiveMessage(connection);
            RecoveryBrokerTest.assertNotNull((Object)m);
        }
        this.assertNoMessagesLeft(connection);
    }

    public static Test suite() {
        return RecoveryBrokerTest.suite(RecoveryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RecoveryBrokerTest.suite());
    }
}

