/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class RestServlet
extends DefaultServlet {
    private File locateFile(HttpServletRequest request) {
        return new File(this.getServletContext().getRealPath(URIUtil.addPaths(request.getServletPath(), request.getPathInfo())));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file = this.locateFile(request);
        if (file.isDirectory()) {
            response.sendError(404);
        } else {
            super.service(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (Log.isDebugEnabled()) {
            Log.debug("RESTful file access: GET request for " + request.getRequestURI());
        }
        super.doGet(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean success;
        File file;
        if (Log.isDebugEnabled()) {
            Log.debug("RESTful file access: PUT request for " + request.getRequestURI());
        }
        if ((file = this.locateFile(request)).exists() && !(success = file.delete())) {
            response.sendError(500);
            return;
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            IO.copy(request.getInputStream(), out);
        }
        catch (IOException e) {
            Log.warn("EXCEPTION ", e);
            out.close();
            throw e;
        }
        response.setStatus(204);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        if (Log.isDebugEnabled()) {
            Log.debug("RESTful file access: DELETE request for " + request.getRequestURI());
        }
        if (!(file = this.locateFile(request)).exists()) {
            response.sendError(404);
            return;
        }
        boolean success = IO.delete(file);
        if (success) {
            response.setStatus(204);
        } else {
            response.sendError(500);
        }
    }
}

