/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;

public class LookaheadLineReader {
    private BufferedReader reader;
    private LinkedList<String> buffer = new LinkedList();

    public LookaheadLineReader(BufferedReader reader) {
        this.reader = reader;
    }

    public String readLine() throws IOException {
        if (this.buffer.isEmpty()) {
            return this.reader.readLine();
        }
        return this.buffer.poll();
    }

    public String peekLine() throws IOException {
        return this.peekLine(1);
    }

    public String peekLine(int lookahead) throws IOException {
        while (this.buffer.size() < lookahead) {
            this.buffer.offer(this.reader.readLine());
        }
        return this.buffer.get(lookahead - 1);
    }

    public void read(int chars) throws IOException {
        String line = this.peekLine();
        if ((line = line.substring(chars)).length() == 0) {
            this.readLine();
        } else {
            this.buffer.remove(0);
            this.buffer.add(0, line);
        }
    }
}

