/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.biobeans;

import fi.csc.microarray.databeans.DataBean;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class BioBean {
    private static final Logger logger = Logger.getLogger(BioBean.class);
    private DataBean dataBean;

    public BioBean(DataBean dataBean) {
        this.dataBean = dataBean;
    }

    public DataBean getProperSource() {
        logger.debug(this.dataBean == null ? "databean is null" : "getting proper source of " + this.dataBean.getName() + ", source count is " + this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).size());
        if (this.dataBean == null || this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 0) {
            return null;
        }
        if (this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).size() == 1) {
            return this.dataBean.getLinkTargets(DataBean.Link.DERIVATION).iterator().next();
        }
        LinkedList<DataBean> sourceCollector = new LinkedList<DataBean>();
        for (DataBean source : this.dataBean.getLinkTargets(DataBean.Link.DERIVATION)) {
            if (!source.queryFeatures("/phenodata").exists()) continue;
            sourceCollector.add(source);
        }
        if (sourceCollector.size() == 0 || sourceCollector.size() > 1) {
            return null;
        }
        return (DataBean)sourceCollector.getFirst();
    }

    public DataBean[] getSourcePath() {
        LinkedList<DataBean> list = new LinkedList<DataBean>();
        if (this.getProperSource() != null) {
            list.addAll(Arrays.asList(new BioBean(this.getProperSource()).getSourcePath()));
        }
        list.add(this.dataBean);
        return list.toArray(new DataBean[0]);
    }
}

