/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.selection.RowChoiceEvent;
import fi.csc.microarray.client.visualisation.methods.threed.AutomatedMovement;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import fi.csc.microarray.client.visualisation.methods.threed.Projection;
import fi.csc.microarray.client.visualisation.methods.threed.Scatterplot3D;
import fi.csc.microarray.client.visualisation.methods.threed.Worker;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.concurrent.PriorityBlockingQueue;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;

public class CoordinateArea
extends JComponent
implements ActionListener,
MouseInputListener,
MouseWheelListener,
PropertyChangeListener {
    private static final int TARGET_FPS = 5;
    private static final double KINETIC_SPEED_FACTOR = 0.002;
    private static long MOVE_TIME_LIMIT = 10L;
    private static final int DRAW_MODE_CHANGE_DELAY = 5;
    private JMenuItem hideSelected;
    private JMenuItem showAll;
    private JMenuItem invertSelection;
    private int tooFastPaintCounter;
    public PaintMode paintMode = PaintMode.GRADIENT;
    private boolean kineticMoveMode = false;
    private LinkedList<DataPoint> selectedPoints;
    private Projection projection;
    private Worker worker;
    protected AutomatedMovement movement;
    private ClientApplication application = Session.getSession().getApplication();
    Scatterplot3D controller;
    final double ANGLE_INCREMENT = 0.002181661564992912;
    private AutomatedMovement.RotationTask kineticMovement;
    private long lastDragEventTime = -1L;
    private int mousePressX = 0;
    private int mousePressY = 0;
    private int mouseX;
    private int mouseY;
    boolean mouseDragged = false;

    public PaintMode getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(PaintMode mode) {
        this.paintMode = mode;
    }

    public CoordinateArea(Scatterplot3D controller) {
        this.controller = controller;
        this.createPopupMenu();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setOpaque(true);
        this.setFocusable(true);
        this.selectedPoints = new LinkedList();
        this.projection = new Projection(controller.getDataModel());
        this.worker = new Worker(this, this.projection);
        this.worker.start();
        this.worker.workRequest();
        this.movement = new AutomatedMovement(this.projection, this.worker);
        this.movement.start();
        this.kineticMovement = this.movement.startKineticMove(25.0, 0.95);
        this.updateSelectedFromApplication();
        this.application.addPropertyChangeListener(this);
    }

    public Projection getProjection() {
        return this.projection;
    }

    protected void paintComponent(Graphics g) {
        long startTime = System.currentTimeMillis();
        if (this.getHeight() <= this.getWidth()) {
            this.projection.setViewWindowWidth(this.projection.getViewWindowHeight() * (double)this.getWidth() / (double)this.getHeight());
        } else {
            this.projection.setViewWindowHeight(this.projection.getViewWindowWidth() * (double)this.getHeight() / (double)this.getWidth());
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PriorityBlockingQueue<Drawable> points = this.projection.getResultPoints();
        if (points != null && !points.isEmpty()) {
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            Drawable p = null;
            while ((p = points.poll()) != null) {
                p.draw(g2d, this.getWidth(), this.getHeight(), this.getPaintMode());
            }
            if (this.mouseDragged) {
                g2d.setColor(Color.WHITE);
                g2d.setStroke(VisualConstants.dashLine);
                int x = this.mousePressX < this.mouseX ? this.mousePressX : this.mouseX;
                int y = this.mousePressY < this.mouseY ? this.mousePressY : this.mouseY;
                int w = Math.abs(this.mouseX - this.mousePressX);
                int h = Math.abs(this.mouseY - this.mousePressY);
                g2d.drawRect(x, y, w, h);
            }
        } else {
            this.worker.workRequest();
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime < 200L) {
            ++this.tooFastPaintCounter;
            if (this.getPaintMode() == PaintMode.PIXEL && this.tooFastPaintCounter > 5) {
                this.tooFastPaintCounter = 0;
                this.setPaintMode(PaintMode.GRADIENT);
            }
        } else if (endTime - startTime > 200L && this.getPaintMode() == PaintMode.GRADIENT) {
            this.setPaintMode(PaintMode.PIXEL);
        }
    }

    public void mouseClicked(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                if (e.isControlDown()) {
                    this.addToSelections(e);
                    break;
                }
                this.selectOne(e);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        this.worker.workRequest();
    }

    public void rotateWithDrag(int mouseX, int mouseY, MouseEvent e) {
        double xfactor = Math.abs(mouseX - this.mousePressX);
        double yfactor = Math.abs(mouseY - this.mousePressY);
        this.controller.stopAutoRotation();
        if (e.isShiftDown()) {
            double deg = this.projection.getZAxisRotation();
            if (this.mousePressX - mouseX < 0) {
                this.projection.setZAxisRotation(deg + 0.002181661564992912 * xfactor);
            } else if (this.mousePressX - mouseX > 0) {
                this.projection.setZAxisRotation(deg - 0.002181661564992912 * xfactor);
            }
            this.zoom((double)(mouseY - this.mousePressY) / 100.0);
        } else if (!this.kineticMoveMode) {
            this.kineticMovement.stop();
            double deg = this.projection.getYAxisRotation();
            if (this.mousePressX - mouseX < 0) {
                this.projection.setYAxisRotation(deg + 0.002181661564992912 * xfactor);
            } else if (this.mousePressX - mouseX > 0) {
                this.projection.setYAxisRotation(deg - 0.002181661564992912 * xfactor);
            }
            deg = this.projection.getXAxisRotation();
            if (this.mousePressY - mouseY < 0) {
                this.projection.setXAxisRotation(deg + 0.002181661564992912 * yfactor);
            } else if (this.mousePressY - mouseY > 0) {
                this.projection.setXAxisRotation(deg - 0.002181661564992912 * yfactor);
            }
            this.kineticMovement.setAngleIncs(0.002 * (double)(mouseY - this.mousePressY), 0.002 * (double)(mouseX - this.mousePressX), 0.0);
        }
        this.mousePressX = mouseX;
        this.mousePressY = mouseY;
        this.lastDragEventTime = System.currentTimeMillis();
        if (!this.kineticMoveMode) {
            this.worker.workRequest();
        }
    }

    public void moveWithDrag(int mouseX, int mouseY, MouseEvent e) {
        double[] orig = this.projection.getPointOfView();
        double divider = this.projection.getDistanceOfProjectionPlaneFromOrigin() * this.projection.getDistanceOfProjectionPlaneFromOrigin();
        orig[0] = orig[0] - (double)(mouseX - this.mousePressX) / divider;
        orig[1] = orig[1] - (double)(mouseY - this.mousePressY) / divider;
        this.projection.setPointOfView(orig);
        this.mousePressX = mouseX;
        this.mousePressY = mouseY;
        this.worker.workRequest();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.kineticMovement.stop();
        this.mousePressX = e.getX();
        this.mousePressY = e.getY();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.controller.getTool() == Scatterplot3D.Tool.ROTATE) {
            this.rotateWithDrag(e.getX(), e.getY(), e);
        } else if (this.controller.getTool() == Scatterplot3D.Tool.MOVE) {
            this.moveWithDrag(e.getX(), e.getY(), e);
        } else if (this.controller.getTool() == Scatterplot3D.Tool.SELECT) {
            this.mouseDragged = true;
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            this.worker.workRequest();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (System.currentTimeMillis() - this.lastDragEventTime < MOVE_TIME_LIMIT) {
            this.kineticMovement = this.movement.restartKineticMove();
        } else {
            this.kineticMovement.stop();
        }
        if (e.getButton() == 1 && this.mouseDragged) {
            this.selectGroup(e, this.mousePressX, this.mousePressY);
            this.mouseDragged = false;
            this.worker.workRequest();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoom((double)e.getWheelRotation() / 10.0);
    }

    private void zoom(double value) {
        double[] pov = this.projection.getPointOfView();
        pov[2] = pov[2] - value;
        this.projection.setPointOfView(pov);
        this.worker.workRequest();
    }

    private void clearSelections() {
        if (this.selectedPoints == null) {
            return;
        }
        for (DataPoint dp : this.selectedPoints) {
            if (dp == null) continue;
            dp.selected = false;
        }
        this.selectedPoints.clear();
        this.controller.getAnnotateList().setSelectedListContent(this.selectedPoints, this, false, this.controller.getFrame().getDatas().get(0));
    }

    private void selectOne(MouseEvent e) {
        this.clearSelections();
        this.selectedPoints = DataPoint.getNearest(e.getX(), e.getY(), this.controller.getDataModel().getDataArray(), 4.0);
        for (DataPoint dp : this.selectedPoints) {
            if (dp == null) continue;
            dp.selected = true;
        }
        this.controller.getAnnotateList().setSelectedListContent(this.selectedPoints, this, true, this.controller.getFrame().getDatas().get(0));
    }

    private void addToSelections(MouseEvent e) {
        LinkedList<DataPoint> newSelection = DataPoint.getNearest(e.getX(), e.getY(), this.controller.getDataModel().getDataArray(), 4.0);
        for (DataPoint dp : newSelection) {
            if (dp == null) continue;
            if (dp.selected) {
                dp.selected = false;
                this.selectedPoints.remove(dp);
                continue;
            }
            dp.selected = true;
            this.selectedPoints.add(dp);
        }
        this.controller.getAnnotateList().setSelectedListContent(this.selectedPoints, this, true, this.controller.getFrame().getDatas().get(0));
    }

    private void selectGroup(MouseEvent e, int x1, int y1) {
        this.clearSelections();
        this.selectedPoints = DataPoint.getGroup(x1, y1, e.getX(), e.getY(), this.controller.getDataModel().getDataArray());
        for (DataPoint dp : this.selectedPoints) {
            if (dp == null) continue;
            dp.selected = true;
        }
        this.controller.getAnnotateList().setSelectedListContent(this.selectedPoints, this, true, this.controller.getFrame().getDatas().get(0));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hideSelected) {
            for (DataPoint d : this.selectedPoints) {
                d.hidden = true;
            }
        } else if (e.getSource() == this.showAll) {
            for (Drawable d : this.controller.getDataModel().getDataArray()) {
                d.hidden = false;
            }
        } else if (e.getSource() == this.invertSelection) {
            this.selectedPoints = new LinkedList();
            for (Drawable d : this.controller.getDataModel().getDataArray()) {
                boolean bl = d.selected = !d.selected;
                if (!(d instanceof DataPoint) || !d.selected) continue;
                this.selectedPoints.add((DataPoint)d);
            }
        }
        this.worker.workRequest();
    }

    public void createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        this.hideSelected = new JMenuItem("Hide selected");
        this.hideSelected.addActionListener(this);
        popup.add(this.hideSelected);
        this.showAll = new JMenuItem("Show all points");
        this.showAll.addActionListener(this);
        popup.add(this.showAll);
        this.invertSelection = new JMenuItem("InvertSelection");
        this.invertSelection.addActionListener(this);
        popup.add(this.invertSelection);
        PopupListener popupListener = new PopupListener(popup);
        this.addMouseListener(popupListener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof RowChoiceEvent && !evt.getSource().equals(this) && ((RowChoiceEvent)evt).getData() == this.controller.getFrame().getDatas().get(0)) {
            this.updateSelectedFromApplication();
            this.repaint();
        }
    }

    private void updateSelectedFromApplication() {
        Drawable[] drawables = this.controller.getDataModel().getDataArray();
        this.clearSelections();
        block0: for (int index : this.application.getSelectionManager().getRowSelectionManager(this.controller.getFrame().getDatas().get(0)).getSelectedRows()) {
            for (Drawable drawable : drawables) {
                DataPoint dp;
                if (!(drawable instanceof DataPoint) || (dp = (DataPoint)drawable).getIndex() != index) continue;
                dp.selected = true;
                this.selectedPoints.add(dp);
                continue block0;
            }
        }
        this.controller.getAnnotateList().setSelectedListContent(this.selectedPoints, this, false, this.controller.getFrame().getDatas().get(0));
    }

    class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int x = e.getX();
                int y = e.getY();
                if (CoordinateArea.this.selectedPoints.isEmpty()) {
                    CoordinateArea.this.hideSelected.setEnabled(false);
                    CoordinateArea.this.invertSelection.setEnabled(false);
                    CoordinateArea.this.showAll.setEnabled(false);
                } else {
                    CoordinateArea.this.hideSelected.setEnabled(true);
                    CoordinateArea.this.invertSelection.setEnabled(true);
                    CoordinateArea.this.showAll.setEnabled(true);
                }
                this.popup.show(e.getComponent(), x, y);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PaintMode {
        PIXEL,
        GRADIENT;

    }
}

