/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport.trimmer;

import fi.csc.microarray.client.dataimport.trimmer.DataTrimmingOperation;

public class ConditionalStringReplace
extends DataTrimmingOperation {
    private double lowerLimit;
    private double upperLimit;
    private String replacement;
    private boolean acceptEqualsFirst;
    private boolean acceptEqualsLast;

    public ConditionalStringReplace(double lowerLimit, double upperLimit, boolean acceptEqualsFirst, boolean acceptEqualsLast, String replacement, int columnIndex) {
        super(columnIndex);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.acceptEqualsFirst = acceptEqualsFirst;
        this.acceptEqualsLast = acceptEqualsLast;
        this.replacement = replacement;
    }

    public String doTrimming(String stringToTrim) {
        double value;
        try {
            value = Double.parseDouble(stringToTrim.trim());
        }
        catch (NumberFormatException nfe) {
            return stringToTrim;
        }
        if (this.acceptEqualsFirst == this.acceptEqualsLast) {
            if (this.acceptEqualsFirst) {
                if (this.lowerLimit <= value && value <= this.upperLimit) {
                    return this.replacement;
                }
                return stringToTrim;
            }
            if (this.lowerLimit < value && value < this.upperLimit) {
                return this.replacement;
            }
            return stringToTrim;
        }
        if (this.acceptEqualsFirst) {
            if (this.lowerLimit <= value && value < this.upperLimit) {
                return this.replacement;
            }
            return stringToTrim;
        }
        if (this.lowerLimit < value && value <= this.upperLimit) {
            return this.replacement;
        }
        return stringToTrim;
    }
}

